/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.models;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="NetworkDeviceData provides network-related details for the allocated device. This information may be filled by drivers or other components to configure or identify the device within a network context.")
public class V1beta1NetworkDeviceData {
    public static final String SERIALIZED_NAME_HARDWARE_ADDRESS = "hardwareAddress";
    @SerializedName(value="hardwareAddress")
    private String hardwareAddress;
    public static final String SERIALIZED_NAME_INTERFACE_NAME = "interfaceName";
    @SerializedName(value="interfaceName")
    private String interfaceName;
    public static final String SERIALIZED_NAME_IPS = "ips";
    @SerializedName(value="ips")
    private List<String> ips = null;

    public V1beta1NetworkDeviceData hardwareAddress(String hardwareAddress) {
        this.hardwareAddress = hardwareAddress;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="HardwareAddress represents the hardware address (e.g. MAC Address) of the device's network interface.  Must not be longer than 128 characters.")
    public String getHardwareAddress() {
        return this.hardwareAddress;
    }

    public void setHardwareAddress(String hardwareAddress) {
        this.hardwareAddress = hardwareAddress;
    }

    public V1beta1NetworkDeviceData interfaceName(String interfaceName) {
        this.interfaceName = interfaceName;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="InterfaceName specifies the name of the network interface associated with the allocated device. This might be the name of a physical or virtual network interface being configured in the pod.  Must not be longer than 256 characters.")
    public String getInterfaceName() {
        return this.interfaceName;
    }

    public void setInterfaceName(String interfaceName) {
        this.interfaceName = interfaceName;
    }

    public V1beta1NetworkDeviceData ips(List<String> ips) {
        this.ips = ips;
        return this;
    }

    public V1beta1NetworkDeviceData addIpsItem(String ipsItem) {
        if (this.ips == null) {
            this.ips = new ArrayList<String>();
        }
        this.ips.add(ipsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="IPs lists the network addresses assigned to the device's network interface. This can include both IPv4 and IPv6 addresses. The IPs are in the CIDR notation, which includes both the address and the associated subnet mask. e.g.: \"192.0.2.5/24\" for IPv4 and \"2001:db8::5/64\" for IPv6.  Must not contain more than 16 entries.")
    public List<String> getIps() {
        return this.ips;
    }

    public void setIps(List<String> ips) {
        this.ips = ips;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V1beta1NetworkDeviceData v1beta1NetworkDeviceData = (V1beta1NetworkDeviceData)o;
        return Objects.equals(this.hardwareAddress, v1beta1NetworkDeviceData.hardwareAddress) && Objects.equals(this.interfaceName, v1beta1NetworkDeviceData.interfaceName) && Objects.equals(this.ips, v1beta1NetworkDeviceData.ips);
    }

    public int hashCode() {
        return Objects.hash(this.hardwareAddress, this.interfaceName, this.ips);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class V1beta1NetworkDeviceData {\n");
        sb.append("    hardwareAddress: ").append(this.toIndentedString(this.hardwareAddress)).append("\n");
        sb.append("    interfaceName: ").append(this.toIndentedString(this.interfaceName)).append("\n");
        sb.append("    ips: ").append(this.toIndentedString(this.ips)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

