/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.models;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.time.OffsetDateTime;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="The device this taint is attached to has the \"effect\" on any claim which does not tolerate the taint and, through the claim, to pods using the claim.")
public class V1beta1DeviceTaint {
    public static final String SERIALIZED_NAME_EFFECT = "effect";
    @SerializedName(value="effect")
    private String effect;
    public static final String SERIALIZED_NAME_KEY = "key";
    @SerializedName(value="key")
    private String key;
    public static final String SERIALIZED_NAME_TIME_ADDED = "timeAdded";
    @SerializedName(value="timeAdded")
    private OffsetDateTime timeAdded;
    public static final String SERIALIZED_NAME_VALUE = "value";
    @SerializedName(value="value")
    private String value;

    public V1beta1DeviceTaint effect(String effect) {
        this.effect = effect;
        return this;
    }

    @ApiModelProperty(required=true, value="The effect of the taint on claims that do not tolerate the taint and through such claims on the pods using them. Valid effects are NoSchedule and NoExecute. PreferNoSchedule as used for nodes is not valid here.")
    public String getEffect() {
        return this.effect;
    }

    public void setEffect(String effect) {
        this.effect = effect;
    }

    public V1beta1DeviceTaint key(String key) {
        this.key = key;
        return this;
    }

    @ApiModelProperty(required=true, value="The taint key to be applied to a device. Must be a label name.")
    public String getKey() {
        return this.key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public V1beta1DeviceTaint timeAdded(OffsetDateTime timeAdded) {
        this.timeAdded = timeAdded;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="TimeAdded represents the time at which the taint was added. Added automatically during create or update if not set.")
    public OffsetDateTime getTimeAdded() {
        return this.timeAdded;
    }

    public void setTimeAdded(OffsetDateTime timeAdded) {
        this.timeAdded = timeAdded;
    }

    public V1beta1DeviceTaint value(String value) {
        this.value = value;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The taint value corresponding to the taint key. Must be a label value.")
    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V1beta1DeviceTaint v1beta1DeviceTaint = (V1beta1DeviceTaint)o;
        return Objects.equals(this.effect, v1beta1DeviceTaint.effect) && Objects.equals(this.key, v1beta1DeviceTaint.key) && Objects.equals(this.timeAdded, v1beta1DeviceTaint.timeAdded) && Objects.equals(this.value, v1beta1DeviceTaint.value);
    }

    public int hashCode() {
        return Objects.hash(this.effect, this.key, this.timeAdded, this.value);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class V1beta1DeviceTaint {\n");
        sb.append("    effect: ").append(this.toIndentedString(this.effect)).append("\n");
        sb.append("    key: ").append(this.toIndentedString(this.key)).append("\n");
        sb.append("    timeAdded: ").append(this.toIndentedString(this.timeAdded)).append("\n");
        sb.append("    value: ").append(this.toIndentedString(this.value)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

