/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.models;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Arrays;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="PodCertificateRequestSpec describes the certificate request.  All fields are immutable after creation.")
public class V1alpha1PodCertificateRequestSpec {
    public static final String SERIALIZED_NAME_MAX_EXPIRATION_SECONDS = "maxExpirationSeconds";
    @SerializedName(value="maxExpirationSeconds")
    private Integer maxExpirationSeconds;
    public static final String SERIALIZED_NAME_NODE_NAME = "nodeName";
    @SerializedName(value="nodeName")
    private String nodeName;
    public static final String SERIALIZED_NAME_NODE_U_I_D = "nodeUID";
    @SerializedName(value="nodeUID")
    private String nodeUID;
    public static final String SERIALIZED_NAME_PKIX_PUBLIC_KEY = "pkixPublicKey";
    @SerializedName(value="pkixPublicKey")
    private byte[] pkixPublicKey;
    public static final String SERIALIZED_NAME_POD_NAME = "podName";
    @SerializedName(value="podName")
    private String podName;
    public static final String SERIALIZED_NAME_POD_U_I_D = "podUID";
    @SerializedName(value="podUID")
    private String podUID;
    public static final String SERIALIZED_NAME_PROOF_OF_POSSESSION = "proofOfPossession";
    @SerializedName(value="proofOfPossession")
    private byte[] proofOfPossession;
    public static final String SERIALIZED_NAME_SERVICE_ACCOUNT_NAME = "serviceAccountName";
    @SerializedName(value="serviceAccountName")
    private String serviceAccountName;
    public static final String SERIALIZED_NAME_SERVICE_ACCOUNT_U_I_D = "serviceAccountUID";
    @SerializedName(value="serviceAccountUID")
    private String serviceAccountUID;
    public static final String SERIALIZED_NAME_SIGNER_NAME = "signerName";
    @SerializedName(value="signerName")
    private String signerName;

    public V1alpha1PodCertificateRequestSpec maxExpirationSeconds(Integer maxExpirationSeconds) {
        this.maxExpirationSeconds = maxExpirationSeconds;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="maxExpirationSeconds is the maximum lifetime permitted for the certificate.  If omitted, kube-apiserver will set it to 86400(24 hours). kube-apiserver will reject values shorter than 3600 (1 hour).  The maximum allowable value is 7862400 (91 days).  The signer implementation is then free to issue a certificate with any lifetime *shorter* than MaxExpirationSeconds, but no shorter than 3600 seconds (1 hour).  This constraint is enforced by kube-apiserver. `kubernetes.io` signers will never issue certificates with a lifetime longer than 24 hours.")
    public Integer getMaxExpirationSeconds() {
        return this.maxExpirationSeconds;
    }

    public void setMaxExpirationSeconds(Integer maxExpirationSeconds) {
        this.maxExpirationSeconds = maxExpirationSeconds;
    }

    public V1alpha1PodCertificateRequestSpec nodeName(String nodeName) {
        this.nodeName = nodeName;
        return this;
    }

    @ApiModelProperty(required=true, value="nodeName is the name of the node the pod is assigned to.")
    public String getNodeName() {
        return this.nodeName;
    }

    public void setNodeName(String nodeName) {
        this.nodeName = nodeName;
    }

    public V1alpha1PodCertificateRequestSpec nodeUID(String nodeUID) {
        this.nodeUID = nodeUID;
        return this;
    }

    @ApiModelProperty(required=true, value="nodeUID is the UID of the node the pod is assigned to.")
    public String getNodeUID() {
        return this.nodeUID;
    }

    public void setNodeUID(String nodeUID) {
        this.nodeUID = nodeUID;
    }

    public V1alpha1PodCertificateRequestSpec pkixPublicKey(byte[] pkixPublicKey) {
        this.pkixPublicKey = pkixPublicKey;
        return this;
    }

    @ApiModelProperty(required=true, value="pkixPublicKey is the PKIX-serialized public key the signer will issue the certificate to.  The key must be one of RSA3072, RSA4096, ECDSAP256, ECDSAP384, ECDSAP521, or ED25519. Note that this list may be expanded in the future.  Signer implementations do not need to support all key types supported by kube-apiserver and kubelet.  If a signer does not support the key type used for a given PodCertificateRequest, it must deny the request by setting a status.conditions entry with a type of \"Denied\" and a reason of \"UnsupportedKeyType\". It may also suggest a key type that it does support in the message field.")
    public byte[] getPkixPublicKey() {
        return this.pkixPublicKey;
    }

    public void setPkixPublicKey(byte[] pkixPublicKey) {
        this.pkixPublicKey = pkixPublicKey;
    }

    public V1alpha1PodCertificateRequestSpec podName(String podName) {
        this.podName = podName;
        return this;
    }

    @ApiModelProperty(required=true, value="podName is the name of the pod into which the certificate will be mounted.")
    public String getPodName() {
        return this.podName;
    }

    public void setPodName(String podName) {
        this.podName = podName;
    }

    public V1alpha1PodCertificateRequestSpec podUID(String podUID) {
        this.podUID = podUID;
        return this;
    }

    @ApiModelProperty(required=true, value="podUID is the UID of the pod into which the certificate will be mounted.")
    public String getPodUID() {
        return this.podUID;
    }

    public void setPodUID(String podUID) {
        this.podUID = podUID;
    }

    public V1alpha1PodCertificateRequestSpec proofOfPossession(byte[] proofOfPossession) {
        this.proofOfPossession = proofOfPossession;
        return this;
    }

    @ApiModelProperty(required=true, value="proofOfPossession proves that the requesting kubelet holds the private key corresponding to pkixPublicKey.  It is contructed by signing the ASCII bytes of the pod's UID using `pkixPublicKey`.  kube-apiserver validates the proof of possession during creation of the PodCertificateRequest.  If the key is an RSA key, then the signature is over the ASCII bytes of the pod UID, using RSASSA-PSS from RFC 8017 (as implemented by the golang function crypto/rsa.SignPSS with nil options).  If the key is an ECDSA key, then the signature is as described by [SEC 1, Version 2.0](https://www.secg.org/sec1-v2.pdf) (as implemented by the golang library function crypto/ecdsa.SignASN1)  If the key is an ED25519 key, the the signature is as described by the [ED25519 Specification](https://ed25519.cr.yp.to/) (as implemented by the golang library crypto/ed25519.Sign).")
    public byte[] getProofOfPossession() {
        return this.proofOfPossession;
    }

    public void setProofOfPossession(byte[] proofOfPossession) {
        this.proofOfPossession = proofOfPossession;
    }

    public V1alpha1PodCertificateRequestSpec serviceAccountName(String serviceAccountName) {
        this.serviceAccountName = serviceAccountName;
        return this;
    }

    @ApiModelProperty(required=true, value="serviceAccountName is the name of the service account the pod is running as.")
    public String getServiceAccountName() {
        return this.serviceAccountName;
    }

    public void setServiceAccountName(String serviceAccountName) {
        this.serviceAccountName = serviceAccountName;
    }

    public V1alpha1PodCertificateRequestSpec serviceAccountUID(String serviceAccountUID) {
        this.serviceAccountUID = serviceAccountUID;
        return this;
    }

    @ApiModelProperty(required=true, value="serviceAccountUID is the UID of the service account the pod is running as.")
    public String getServiceAccountUID() {
        return this.serviceAccountUID;
    }

    public void setServiceAccountUID(String serviceAccountUID) {
        this.serviceAccountUID = serviceAccountUID;
    }

    public V1alpha1PodCertificateRequestSpec signerName(String signerName) {
        this.signerName = signerName;
        return this;
    }

    @ApiModelProperty(required=true, value="signerName indicates the requested signer.  All signer names beginning with `kubernetes.io` are reserved for use by the Kubernetes project.  There is currently one well-known signer documented by the Kubernetes project, `kubernetes.io/kube-apiserver-client-pod`, which will issue client certificates understood by kube-apiserver.  It is currently unimplemented.")
    public String getSignerName() {
        return this.signerName;
    }

    public void setSignerName(String signerName) {
        this.signerName = signerName;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V1alpha1PodCertificateRequestSpec v1alpha1PodCertificateRequestSpec = (V1alpha1PodCertificateRequestSpec)o;
        return Objects.equals(this.maxExpirationSeconds, v1alpha1PodCertificateRequestSpec.maxExpirationSeconds) && Objects.equals(this.nodeName, v1alpha1PodCertificateRequestSpec.nodeName) && Objects.equals(this.nodeUID, v1alpha1PodCertificateRequestSpec.nodeUID) && Arrays.equals(this.pkixPublicKey, v1alpha1PodCertificateRequestSpec.pkixPublicKey) && Objects.equals(this.podName, v1alpha1PodCertificateRequestSpec.podName) && Objects.equals(this.podUID, v1alpha1PodCertificateRequestSpec.podUID) && Arrays.equals(this.proofOfPossession, v1alpha1PodCertificateRequestSpec.proofOfPossession) && Objects.equals(this.serviceAccountName, v1alpha1PodCertificateRequestSpec.serviceAccountName) && Objects.equals(this.serviceAccountUID, v1alpha1PodCertificateRequestSpec.serviceAccountUID) && Objects.equals(this.signerName, v1alpha1PodCertificateRequestSpec.signerName);
    }

    public int hashCode() {
        return Objects.hash(this.maxExpirationSeconds, this.nodeName, this.nodeUID, Arrays.hashCode(this.pkixPublicKey), this.podName, this.podUID, Arrays.hashCode(this.proofOfPossession), this.serviceAccountName, this.serviceAccountUID, this.signerName);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class V1alpha1PodCertificateRequestSpec {\n");
        sb.append("    maxExpirationSeconds: ").append(this.toIndentedString(this.maxExpirationSeconds)).append("\n");
        sb.append("    nodeName: ").append(this.toIndentedString(this.nodeName)).append("\n");
        sb.append("    nodeUID: ").append(this.toIndentedString(this.nodeUID)).append("\n");
        sb.append("    pkixPublicKey: ").append(this.toIndentedString(this.pkixPublicKey)).append("\n");
        sb.append("    podName: ").append(this.toIndentedString(this.podName)).append("\n");
        sb.append("    podUID: ").append(this.toIndentedString(this.podUID)).append("\n");
        sb.append("    proofOfPossession: ").append(this.toIndentedString(this.proofOfPossession)).append("\n");
        sb.append("    serviceAccountName: ").append(this.toIndentedString(this.serviceAccountName)).append("\n");
        sb.append("    serviceAccountUID: ").append(this.toIndentedString(this.serviceAccountUID)).append("\n");
        sb.append("    signerName: ").append(this.toIndentedString(this.signerName)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

