/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.models;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

@ApiModel(description="ResourcePool describes the pool that ResourceSlices belong to.")
public class V1ResourcePool {
    public static final String SERIALIZED_NAME_GENERATION = "generation";
    @SerializedName(value="generation")
    private Long generation;
    public static final String SERIALIZED_NAME_NAME = "name";
    @SerializedName(value="name")
    private String name;
    public static final String SERIALIZED_NAME_RESOURCE_SLICE_COUNT = "resourceSliceCount";
    @SerializedName(value="resourceSliceCount")
    private Long resourceSliceCount;

    public V1ResourcePool generation(Long generation) {
        this.generation = generation;
        return this;
    }

    @ApiModelProperty(required=true, value="Generation tracks the change in a pool over time. Whenever a driver changes something about one or more of the resources in a pool, it must change the generation in all ResourceSlices which are part of that pool. Consumers of ResourceSlices should only consider resources from the pool with the highest generation number. The generation may be reset by drivers, which should be fine for consumers, assuming that all ResourceSlices in a pool are updated to match or deleted.  Combined with ResourceSliceCount, this mechanism enables consumers to detect pools which are comprised of multiple ResourceSlices and are in an incomplete state.")
    public Long getGeneration() {
        return this.generation;
    }

    public void setGeneration(Long generation) {
        this.generation = generation;
    }

    public V1ResourcePool name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(required=true, value="Name is used to identify the pool. For node-local devices, this is often the node name, but this is not required.  It must not be longer than 253 characters and must consist of one or more DNS sub-domains separated by slashes. This field is immutable.")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public V1ResourcePool resourceSliceCount(Long resourceSliceCount) {
        this.resourceSliceCount = resourceSliceCount;
        return this;
    }

    @ApiModelProperty(required=true, value="ResourceSliceCount is the total number of ResourceSlices in the pool at this generation number. Must be greater than zero.  Consumers can use this to check whether they have seen all ResourceSlices belonging to the same pool.")
    public Long getResourceSliceCount() {
        return this.resourceSliceCount;
    }

    public void setResourceSliceCount(Long resourceSliceCount) {
        this.resourceSliceCount = resourceSliceCount;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V1ResourcePool v1ResourcePool = (V1ResourcePool)o;
        return Objects.equals(this.generation, v1ResourcePool.generation) && Objects.equals(this.name, v1ResourcePool.name) && Objects.equals(this.resourceSliceCount, v1ResourcePool.resourceSliceCount);
    }

    public int hashCode() {
        return Objects.hash(this.generation, this.name, this.resourceSliceCount);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class V1ResourcePool {\n");
        sb.append("    generation: ").append(this.toIndentedString(this.generation)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    resourceSliceCount: ").append(this.toIndentedString(this.resourceSliceCount)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

