/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.models;

import com.google.gson.annotations.SerializedName;
import io.kubernetes.client.openapi.models.V1LabelSelectorRequirement;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="LabelSelectorAttributes indicates a label limited access. Webhook authors are encouraged to * ensure rawSelector and requirements are not both set * consider the requirements field if set * not try to parse or consider the rawSelector field if set. This is to avoid another CVE-2022-2880 (i.e. getting different systems to agree on how exactly to parse a query is not something we want), see https://www.oxeye.io/resources/golang-parameter-smuggling-attack for more details. For the *SubjectAccessReview endpoints of the kube-apiserver: * If rawSelector is empty and requirements are empty, the request is not limited. * If rawSelector is present and requirements are empty, the rawSelector will be parsed and limited if the parsing succeeds. * If rawSelector is empty and requirements are present, the requirements should be honored * If rawSelector is present and requirements are present, the request is invalid.")
public class V1LabelSelectorAttributes {
    public static final String SERIALIZED_NAME_RAW_SELECTOR = "rawSelector";
    @SerializedName(value="rawSelector")
    private String rawSelector;
    public static final String SERIALIZED_NAME_REQUIREMENTS = "requirements";
    @SerializedName(value="requirements")
    private List<V1LabelSelectorRequirement> requirements = null;

    public V1LabelSelectorAttributes rawSelector(String rawSelector) {
        this.rawSelector = rawSelector;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="rawSelector is the serialization of a field selector that would be included in a query parameter. Webhook implementations are encouraged to ignore rawSelector. The kube-apiserver's *SubjectAccessReview will parse the rawSelector as long as the requirements are not present.")
    public String getRawSelector() {
        return this.rawSelector;
    }

    public void setRawSelector(String rawSelector) {
        this.rawSelector = rawSelector;
    }

    public V1LabelSelectorAttributes requirements(List<V1LabelSelectorRequirement> requirements) {
        this.requirements = requirements;
        return this;
    }

    public V1LabelSelectorAttributes addRequirementsItem(V1LabelSelectorRequirement requirementsItem) {
        if (this.requirements == null) {
            this.requirements = new ArrayList<V1LabelSelectorRequirement>();
        }
        this.requirements.add(requirementsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="requirements is the parsed interpretation of a label selector. All requirements must be met for a resource instance to match the selector. Webhook implementations should handle requirements, but how to handle them is up to the webhook. Since requirements can only limit the request, it is safe to authorize as unlimited request if the requirements are not understood.")
    public List<V1LabelSelectorRequirement> getRequirements() {
        return this.requirements;
    }

    public void setRequirements(List<V1LabelSelectorRequirement> requirements) {
        this.requirements = requirements;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V1LabelSelectorAttributes v1LabelSelectorAttributes = (V1LabelSelectorAttributes)o;
        return Objects.equals(this.rawSelector, v1LabelSelectorAttributes.rawSelector) && Objects.equals(this.requirements, v1LabelSelectorAttributes.requirements);
    }

    public int hashCode() {
        return Objects.hash(this.rawSelector, this.requirements);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class V1LabelSelectorAttributes {\n");
        sb.append("    rawSelector: ").append(this.toIndentedString(this.rawSelector)).append("\n");
        sb.append("    requirements: ").append(this.toIndentedString(this.requirements)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

