/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.models;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="FileKeySelector selects a key of the env file.")
public class V1FileKeySelector {
    public static final String SERIALIZED_NAME_KEY = "key";
    @SerializedName(value="key")
    private String key;
    public static final String SERIALIZED_NAME_OPTIONAL = "optional";
    @SerializedName(value="optional")
    private Boolean optional;
    public static final String SERIALIZED_NAME_PATH = "path";
    @SerializedName(value="path")
    private String path;
    public static final String SERIALIZED_NAME_VOLUME_NAME = "volumeName";
    @SerializedName(value="volumeName")
    private String volumeName;

    public V1FileKeySelector key(String key) {
        this.key = key;
        return this;
    }

    @ApiModelProperty(required=true, value="The key within the env file. An invalid key will prevent the pod from starting. The keys defined within a source may consist of any printable ASCII characters except '='. During Alpha stage of the EnvFiles feature gate, the key size is limited to 128 characters.")
    public String getKey() {
        return this.key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public V1FileKeySelector optional(Boolean optional) {
        this.optional = optional;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Specify whether the file or its key must be defined. If the file or key does not exist, then the env var is not published. If optional is set to true and the specified key does not exist, the environment variable will not be set in the Pod's containers.  If optional is set to false and the specified key does not exist, an error will be returned during Pod creation.")
    public Boolean getOptional() {
        return this.optional;
    }

    public void setOptional(Boolean optional) {
        this.optional = optional;
    }

    public V1FileKeySelector path(String path) {
        this.path = path;
        return this;
    }

    @ApiModelProperty(required=true, value="The path within the volume from which to select the file. Must be relative and may not contain the '..' path or start with '..'.")
    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public V1FileKeySelector volumeName(String volumeName) {
        this.volumeName = volumeName;
        return this;
    }

    @ApiModelProperty(required=true, value="The name of the volume mount containing the env file.")
    public String getVolumeName() {
        return this.volumeName;
    }

    public void setVolumeName(String volumeName) {
        this.volumeName = volumeName;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V1FileKeySelector v1FileKeySelector = (V1FileKeySelector)o;
        return Objects.equals(this.key, v1FileKeySelector.key) && Objects.equals(this.optional, v1FileKeySelector.optional) && Objects.equals(this.path, v1FileKeySelector.path) && Objects.equals(this.volumeName, v1FileKeySelector.volumeName);
    }

    public int hashCode() {
        return Objects.hash(this.key, this.optional, this.path, this.volumeName);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class V1FileKeySelector {\n");
        sb.append("    key: ").append(this.toIndentedString(this.key)).append("\n");
        sb.append("    optional: ").append(this.toIndentedString(this.optional)).append("\n");
        sb.append("    path: ").append(this.toIndentedString(this.path)).append("\n");
        sb.append("    volumeName: ").append(this.toIndentedString(this.volumeName)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

