/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.models;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.kubernetes.client.openapi.JSON;
import io.kubernetes.client.openapi.models.V1PersistentVolumeSpec;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import jakarta.annotation.Nullable;
import java.io.IOException;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

@ApiModel(description="VolumeAttachmentSource represents a volume that should be attached. Right now only PersistentVolumes can be attached via external attacher, in the future we may allow also inline volumes in pods. Exactly one member can be set.")
public class V1VolumeAttachmentSource {
    public static final String SERIALIZED_NAME_INLINE_VOLUME_SPEC = "inlineVolumeSpec";
    @SerializedName(value="inlineVolumeSpec")
    @Nullable
    private V1PersistentVolumeSpec inlineVolumeSpec;
    public static final String SERIALIZED_NAME_PERSISTENT_VOLUME_NAME = "persistentVolumeName";
    @SerializedName(value="persistentVolumeName")
    @Nullable
    private String persistentVolumeName;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public V1VolumeAttachmentSource inlineVolumeSpec(@Nullable V1PersistentVolumeSpec inlineVolumeSpec) {
        this.inlineVolumeSpec = inlineVolumeSpec;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public V1PersistentVolumeSpec getInlineVolumeSpec() {
        return this.inlineVolumeSpec;
    }

    public void setInlineVolumeSpec(@Nullable V1PersistentVolumeSpec inlineVolumeSpec) {
        this.inlineVolumeSpec = inlineVolumeSpec;
    }

    public V1VolumeAttachmentSource persistentVolumeName(@Nullable String persistentVolumeName) {
        this.persistentVolumeName = persistentVolumeName;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="persistentVolumeName represents the name of the persistent volume to attach.")
    public String getPersistentVolumeName() {
        return this.persistentVolumeName;
    }

    public void setPersistentVolumeName(@Nullable String persistentVolumeName) {
        this.persistentVolumeName = persistentVolumeName;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V1VolumeAttachmentSource v1VolumeAttachmentSource = (V1VolumeAttachmentSource)o;
        return Objects.equals(this.inlineVolumeSpec, v1VolumeAttachmentSource.inlineVolumeSpec) && Objects.equals(this.persistentVolumeName, v1VolumeAttachmentSource.persistentVolumeName);
    }

    public int hashCode() {
        return Objects.hash(this.inlineVolumeSpec, this.persistentVolumeName);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class V1VolumeAttachmentSource {\n");
        sb.append("    inlineVolumeSpec: ").append(this.toIndentedString(this.inlineVolumeSpec)).append("\n");
        sb.append("    persistentVolumeName: ").append(this.toIndentedString(this.persistentVolumeName)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonElement(JsonElement jsonElement) throws IOException {
        if (jsonElement == null && !openapiRequiredFields.isEmpty()) {
            throw new IllegalArgumentException(String.format("The required field(s) %s in V1VolumeAttachmentSource is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        Set entries = jsonElement.getAsJsonObject().entrySet();
        for (Map.Entry entry : entries) {
            if (openapiFields.contains(entry.getKey())) continue;
            throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `V1VolumeAttachmentSource` properties. JSON: %s", entry.getKey(), jsonElement.toString()));
        }
        JsonObject jsonObj = jsonElement.getAsJsonObject();
        if (jsonObj.get(SERIALIZED_NAME_INLINE_VOLUME_SPEC) != null && !jsonObj.get(SERIALIZED_NAME_INLINE_VOLUME_SPEC).isJsonNull()) {
            V1PersistentVolumeSpec.validateJsonElement(jsonObj.get(SERIALIZED_NAME_INLINE_VOLUME_SPEC));
        }
        if (jsonObj.get(SERIALIZED_NAME_PERSISTENT_VOLUME_NAME) != null && !jsonObj.get(SERIALIZED_NAME_PERSISTENT_VOLUME_NAME).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_PERSISTENT_VOLUME_NAME).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `persistentVolumeName` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_PERSISTENT_VOLUME_NAME).toString()));
        }
    }

    public static V1VolumeAttachmentSource fromJson(String jsonString) throws IOException {
        return (V1VolumeAttachmentSource)JSON.getGson().fromJson(jsonString, V1VolumeAttachmentSource.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_INLINE_VOLUME_SPEC);
        openapiFields.add(SERIALIZED_NAME_PERSISTENT_VOLUME_NAME);
        openapiRequiredFields = new HashSet();
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!V1VolumeAttachmentSource.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(V1VolumeAttachmentSource.class));
            return new TypeAdapter<V1VolumeAttachmentSource>(){

                public void write(JsonWriter out, V1VolumeAttachmentSource value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    elementAdapter.write(out, (Object)obj);
                }

                public V1VolumeAttachmentSource read(JsonReader in) throws IOException {
                    JsonElement jsonElement = (JsonElement)elementAdapter.read(in);
                    V1VolumeAttachmentSource.validateJsonElement(jsonElement);
                    return (V1VolumeAttachmentSource)thisAdapter.fromJsonTree(jsonElement);
                }
            }.nullSafe();
        }
    }
}

