/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.models;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.kubernetes.client.openapi.JSON;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import jakarta.annotation.Nonnull;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

@ApiModel(description="EventSeries contain information on series of events, i.e. thing that was/is happening continuously for some time. How often to update the EventSeries is up to the event reporters. The default event reporter in \"k8s.io/client-go/tools/events/event_broadcaster.go\" shows how this struct is updated on heartbeats and can guide customized reporter implementations.")
public class EventsV1EventSeries {
    public static final String SERIALIZED_NAME_COUNT = "count";
    @SerializedName(value="count")
    @Nonnull
    private Integer count;
    public static final String SERIALIZED_NAME_LAST_OBSERVED_TIME = "lastObservedTime";
    @SerializedName(value="lastObservedTime")
    @Nonnull
    private OffsetDateTime lastObservedTime;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public EventsV1EventSeries count(@Nonnull Integer count) {
        this.count = count;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="count is the number of occurrences in this series up to the last heartbeat time.")
    public Integer getCount() {
        return this.count;
    }

    public void setCount(@Nonnull Integer count) {
        this.count = count;
    }

    public EventsV1EventSeries lastObservedTime(@Nonnull OffsetDateTime lastObservedTime) {
        this.lastObservedTime = lastObservedTime;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="lastObservedTime is the time when last Event from the series was seen before last heartbeat.")
    public OffsetDateTime getLastObservedTime() {
        return this.lastObservedTime;
    }

    public void setLastObservedTime(@Nonnull OffsetDateTime lastObservedTime) {
        this.lastObservedTime = lastObservedTime;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EventsV1EventSeries eventsV1EventSeries = (EventsV1EventSeries)o;
        return Objects.equals(this.count, eventsV1EventSeries.count) && Objects.equals(this.lastObservedTime, eventsV1EventSeries.lastObservedTime);
    }

    public int hashCode() {
        return Objects.hash(this.count, this.lastObservedTime);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class EventsV1EventSeries {\n");
        sb.append("    count: ").append(this.toIndentedString(this.count)).append("\n");
        sb.append("    lastObservedTime: ").append(this.toIndentedString(this.lastObservedTime)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonElement(JsonElement jsonElement) throws IOException {
        if (jsonElement == null && !openapiRequiredFields.isEmpty()) {
            throw new IllegalArgumentException(String.format("The required field(s) %s in EventsV1EventSeries is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        Set entries = jsonElement.getAsJsonObject().entrySet();
        for (Map.Entry entry : entries) {
            if (openapiFields.contains(entry.getKey())) continue;
            throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `EventsV1EventSeries` properties. JSON: %s", entry.getKey(), jsonElement.toString()));
        }
        for (String requiredField : openapiRequiredFields) {
            if (jsonElement.getAsJsonObject().get(requiredField) != null) continue;
            throw new IllegalArgumentException(String.format("The required field `%s` is not found in the JSON string: %s", requiredField, jsonElement.toString()));
        }
        JsonObject jsonObj = jsonElement.getAsJsonObject();
    }

    public static EventsV1EventSeries fromJson(String jsonString) throws IOException {
        return (EventsV1EventSeries)JSON.getGson().fromJson(jsonString, EventsV1EventSeries.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_COUNT);
        openapiFields.add(SERIALIZED_NAME_LAST_OBSERVED_TIME);
        openapiRequiredFields = new HashSet();
        openapiRequiredFields.add(SERIALIZED_NAME_COUNT);
        openapiRequiredFields.add(SERIALIZED_NAME_LAST_OBSERVED_TIME);
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!EventsV1EventSeries.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(EventsV1EventSeries.class));
            return new TypeAdapter<EventsV1EventSeries>(){

                public void write(JsonWriter out, EventsV1EventSeries value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    elementAdapter.write(out, (Object)obj);
                }

                public EventsV1EventSeries read(JsonReader in) throws IOException {
                    JsonElement jsonElement = (JsonElement)elementAdapter.read(in);
                    EventsV1EventSeries.validateJsonElement(jsonElement);
                    return (EventsV1EventSeries)thisAdapter.fromJsonTree(jsonElement);
                }
            }.nullSafe();
        }
    }
}

