/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.models;

import com.google.gson.annotations.SerializedName;
import io.kubernetes.client.openapi.models.V1beta2DeviceClassConfiguration;
import io.kubernetes.client.openapi.models.V1beta2DeviceSelector;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="DeviceClassSpec is used in a [DeviceClass] to define what can be allocated and how to configure it.")
public class V1beta2DeviceClassSpec {
    public static final String SERIALIZED_NAME_CONFIG = "config";
    @SerializedName(value="config")
    private List<V1beta2DeviceClassConfiguration> config = null;
    public static final String SERIALIZED_NAME_SELECTORS = "selectors";
    @SerializedName(value="selectors")
    private List<V1beta2DeviceSelector> selectors = null;

    public V1beta2DeviceClassSpec config(List<V1beta2DeviceClassConfiguration> config) {
        this.config = config;
        return this;
    }

    public V1beta2DeviceClassSpec addConfigItem(V1beta2DeviceClassConfiguration configItem) {
        if (this.config == null) {
            this.config = new ArrayList<V1beta2DeviceClassConfiguration>();
        }
        this.config.add(configItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Config defines configuration parameters that apply to each device that is claimed via this class. Some classses may potentially be satisfied by multiple drivers, so each instance of a vendor configuration applies to exactly one driver.  They are passed to the driver, but are not considered while allocating the claim.")
    public List<V1beta2DeviceClassConfiguration> getConfig() {
        return this.config;
    }

    public void setConfig(List<V1beta2DeviceClassConfiguration> config) {
        this.config = config;
    }

    public V1beta2DeviceClassSpec selectors(List<V1beta2DeviceSelector> selectors) {
        this.selectors = selectors;
        return this;
    }

    public V1beta2DeviceClassSpec addSelectorsItem(V1beta2DeviceSelector selectorsItem) {
        if (this.selectors == null) {
            this.selectors = new ArrayList<V1beta2DeviceSelector>();
        }
        this.selectors.add(selectorsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Each selector must be satisfied by a device which is claimed via this class.")
    public List<V1beta2DeviceSelector> getSelectors() {
        return this.selectors;
    }

    public void setSelectors(List<V1beta2DeviceSelector> selectors) {
        this.selectors = selectors;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V1beta2DeviceClassSpec v1beta2DeviceClassSpec = (V1beta2DeviceClassSpec)o;
        return Objects.equals(this.config, v1beta2DeviceClassSpec.config) && Objects.equals(this.selectors, v1beta2DeviceClassSpec.selectors);
    }

    public int hashCode() {
        return Objects.hash(this.config, this.selectors);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class V1beta2DeviceClassSpec {\n");
        sb.append("    config: ").append(this.toIndentedString(this.config)).append("\n");
        sb.append("    selectors: ").append(this.toIndentedString(this.selectors)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

