/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.models;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.kubernetes.client.openapi.JSON;
import io.kubernetes.client.openapi.models.V2MetricValueStatus;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import jakarta.annotation.Nonnull;
import java.io.IOException;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

@ApiModel(description="ContainerResourceMetricStatus indicates the current value of a resource metric known to Kubernetes, as specified in requests and limits, describing a single container in each pod in the current scale target (e.g. CPU or memory).  Such metrics are built in to Kubernetes, and have special scaling options on top of those available to normal per-pod metrics using the \"pods\" source.")
public class V2ContainerResourceMetricStatus {
    public static final String SERIALIZED_NAME_CONTAINER = "container";
    @SerializedName(value="container")
    private String container;
    public static final String SERIALIZED_NAME_CURRENT = "current";
    @SerializedName(value="current")
    private V2MetricValueStatus current;
    public static final String SERIALIZED_NAME_NAME = "name";
    @SerializedName(value="name")
    private String name;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public V2ContainerResourceMetricStatus container(String container) {
        this.container = container;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="container is the name of the container in the pods of the scaling target")
    public String getContainer() {
        return this.container;
    }

    public void setContainer(String container) {
        this.container = container;
    }

    public V2ContainerResourceMetricStatus current(V2MetricValueStatus current) {
        this.current = current;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="")
    public V2MetricValueStatus getCurrent() {
        return this.current;
    }

    public void setCurrent(V2MetricValueStatus current) {
        this.current = current;
    }

    public V2ContainerResourceMetricStatus name(String name) {
        this.name = name;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="name is the name of the resource in question.")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V2ContainerResourceMetricStatus v2ContainerResourceMetricStatus = (V2ContainerResourceMetricStatus)o;
        return Objects.equals(this.container, v2ContainerResourceMetricStatus.container) && Objects.equals(this.current, v2ContainerResourceMetricStatus.current) && Objects.equals(this.name, v2ContainerResourceMetricStatus.name);
    }

    public int hashCode() {
        return Objects.hash(this.container, this.current, this.name);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class V2ContainerResourceMetricStatus {\n");
        sb.append("    container: ").append(this.toIndentedString(this.container)).append("\n");
        sb.append("    current: ").append(this.toIndentedString(this.current)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonElement(JsonElement jsonElement) throws IOException {
        if (jsonElement == null && !openapiRequiredFields.isEmpty()) {
            throw new IllegalArgumentException(String.format("The required field(s) %s in V2ContainerResourceMetricStatus is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        Set entries = jsonElement.getAsJsonObject().entrySet();
        for (Map.Entry entry : entries) {
            if (openapiFields.contains(entry.getKey())) continue;
            throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `V2ContainerResourceMetricStatus` properties. JSON: %s", entry.getKey(), jsonElement.toString()));
        }
        for (String requiredField : openapiRequiredFields) {
            if (jsonElement.getAsJsonObject().get(requiredField) != null) continue;
            throw new IllegalArgumentException(String.format("The required field `%s` is not found in the JSON string: %s", requiredField, jsonElement.toString()));
        }
        JsonObject jsonObj = jsonElement.getAsJsonObject();
        if (!jsonObj.get(SERIALIZED_NAME_CONTAINER).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `container` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_CONTAINER).toString()));
        }
        V2MetricValueStatus.validateJsonElement(jsonObj.get(SERIALIZED_NAME_CURRENT));
        if (!jsonObj.get(SERIALIZED_NAME_NAME).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `name` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_NAME).toString()));
        }
    }

    public static V2ContainerResourceMetricStatus fromJson(String jsonString) throws IOException {
        return (V2ContainerResourceMetricStatus)JSON.getGson().fromJson(jsonString, V2ContainerResourceMetricStatus.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_CONTAINER);
        openapiFields.add(SERIALIZED_NAME_CURRENT);
        openapiFields.add(SERIALIZED_NAME_NAME);
        openapiRequiredFields = new HashSet();
        openapiRequiredFields.add(SERIALIZED_NAME_CONTAINER);
        openapiRequiredFields.add(SERIALIZED_NAME_CURRENT);
        openapiRequiredFields.add(SERIALIZED_NAME_NAME);
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!V2ContainerResourceMetricStatus.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(V2ContainerResourceMetricStatus.class));
            return new TypeAdapter<V2ContainerResourceMetricStatus>(){

                public void write(JsonWriter out, V2ContainerResourceMetricStatus value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    elementAdapter.write(out, (Object)obj);
                }

                public V2ContainerResourceMetricStatus read(JsonReader in) throws IOException {
                    JsonElement jsonElement = (JsonElement)elementAdapter.read(in);
                    V2ContainerResourceMetricStatus.validateJsonElement(jsonElement);
                    return (V2ContainerResourceMetricStatus)thisAdapter.fromJsonTree(jsonElement);
                }
            }.nullSafe();
        }
    }
}

