/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.models;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.kubernetes.client.openapi.JSON;
import io.kubernetes.client.openapi.models.V1LabelSelector;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.io.IOException;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

@ApiModel(description="ClusterTrustBundleProjection describes how to select a set of ClusterTrustBundle objects and project their contents into the pod filesystem.")
public class V1ClusterTrustBundleProjection {
    public static final String SERIALIZED_NAME_LABEL_SELECTOR = "labelSelector";
    @SerializedName(value="labelSelector")
    private V1LabelSelector labelSelector;
    public static final String SERIALIZED_NAME_NAME = "name";
    @SerializedName(value="name")
    private String name;
    public static final String SERIALIZED_NAME_OPTIONAL = "optional";
    @SerializedName(value="optional")
    private Boolean optional;
    public static final String SERIALIZED_NAME_PATH = "path";
    @SerializedName(value="path")
    private String path;
    public static final String SERIALIZED_NAME_SIGNER_NAME = "signerName";
    @SerializedName(value="signerName")
    private String signerName;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public V1ClusterTrustBundleProjection labelSelector(V1LabelSelector labelSelector) {
        this.labelSelector = labelSelector;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public V1LabelSelector getLabelSelector() {
        return this.labelSelector;
    }

    public void setLabelSelector(V1LabelSelector labelSelector) {
        this.labelSelector = labelSelector;
    }

    public V1ClusterTrustBundleProjection name(String name) {
        this.name = name;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Select a single ClusterTrustBundle by object name.  Mutually-exclusive with signerName and labelSelector.")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public V1ClusterTrustBundleProjection optional(Boolean optional) {
        this.optional = optional;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="If true, don't block pod startup if the referenced ClusterTrustBundle(s) aren't available.  If using name, then the named ClusterTrustBundle is allowed not to exist.  If using signerName, then the combination of signerName and labelSelector is allowed to match zero ClusterTrustBundles.")
    public Boolean getOptional() {
        return this.optional;
    }

    public void setOptional(Boolean optional) {
        this.optional = optional;
    }

    public V1ClusterTrustBundleProjection path(String path) {
        this.path = path;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="Relative path from the volume root to write the bundle.")
    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public V1ClusterTrustBundleProjection signerName(String signerName) {
        this.signerName = signerName;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Select all ClusterTrustBundles that match this signer name. Mutually-exclusive with name.  The contents of all selected ClusterTrustBundles will be unified and deduplicated.")
    public String getSignerName() {
        return this.signerName;
    }

    public void setSignerName(String signerName) {
        this.signerName = signerName;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V1ClusterTrustBundleProjection v1ClusterTrustBundleProjection = (V1ClusterTrustBundleProjection)o;
        return Objects.equals(this.labelSelector, v1ClusterTrustBundleProjection.labelSelector) && Objects.equals(this.name, v1ClusterTrustBundleProjection.name) && Objects.equals(this.optional, v1ClusterTrustBundleProjection.optional) && Objects.equals(this.path, v1ClusterTrustBundleProjection.path) && Objects.equals(this.signerName, v1ClusterTrustBundleProjection.signerName);
    }

    public int hashCode() {
        return Objects.hash(this.labelSelector, this.name, this.optional, this.path, this.signerName);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class V1ClusterTrustBundleProjection {\n");
        sb.append("    labelSelector: ").append(this.toIndentedString(this.labelSelector)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    optional: ").append(this.toIndentedString(this.optional)).append("\n");
        sb.append("    path: ").append(this.toIndentedString(this.path)).append("\n");
        sb.append("    signerName: ").append(this.toIndentedString(this.signerName)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonElement(JsonElement jsonElement) throws IOException {
        if (jsonElement == null && !openapiRequiredFields.isEmpty()) {
            throw new IllegalArgumentException(String.format("The required field(s) %s in V1ClusterTrustBundleProjection is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        Set entries = jsonElement.getAsJsonObject().entrySet();
        for (Map.Entry entry : entries) {
            if (openapiFields.contains(entry.getKey())) continue;
            throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `V1ClusterTrustBundleProjection` properties. JSON: %s", entry.getKey(), jsonElement.toString()));
        }
        for (String requiredField : openapiRequiredFields) {
            if (jsonElement.getAsJsonObject().get(requiredField) != null) continue;
            throw new IllegalArgumentException(String.format("The required field `%s` is not found in the JSON string: %s", requiredField, jsonElement.toString()));
        }
        JsonObject jsonObj = jsonElement.getAsJsonObject();
        if (jsonObj.get(SERIALIZED_NAME_LABEL_SELECTOR) != null && !jsonObj.get(SERIALIZED_NAME_LABEL_SELECTOR).isJsonNull()) {
            V1LabelSelector.validateJsonElement(jsonObj.get(SERIALIZED_NAME_LABEL_SELECTOR));
        }
        if (jsonObj.get(SERIALIZED_NAME_NAME) != null && !jsonObj.get(SERIALIZED_NAME_NAME).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_NAME).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `name` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_NAME).toString()));
        }
        if (!jsonObj.get(SERIALIZED_NAME_PATH).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `path` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_PATH).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_SIGNER_NAME) != null && !jsonObj.get(SERIALIZED_NAME_SIGNER_NAME).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_SIGNER_NAME).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `signerName` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_SIGNER_NAME).toString()));
        }
    }

    public static V1ClusterTrustBundleProjection fromJson(String jsonString) throws IOException {
        return (V1ClusterTrustBundleProjection)JSON.getGson().fromJson(jsonString, V1ClusterTrustBundleProjection.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_LABEL_SELECTOR);
        openapiFields.add(SERIALIZED_NAME_NAME);
        openapiFields.add(SERIALIZED_NAME_OPTIONAL);
        openapiFields.add(SERIALIZED_NAME_PATH);
        openapiFields.add(SERIALIZED_NAME_SIGNER_NAME);
        openapiRequiredFields = new HashSet();
        openapiRequiredFields.add(SERIALIZED_NAME_PATH);
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!V1ClusterTrustBundleProjection.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(V1ClusterTrustBundleProjection.class));
            return new TypeAdapter<V1ClusterTrustBundleProjection>(){

                public void write(JsonWriter out, V1ClusterTrustBundleProjection value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    elementAdapter.write(out, (Object)obj);
                }

                public V1ClusterTrustBundleProjection read(JsonReader in) throws IOException {
                    JsonElement jsonElement = (JsonElement)elementAdapter.read(in);
                    V1ClusterTrustBundleProjection.validateJsonElement(jsonElement);
                    return (V1ClusterTrustBundleProjection)thisAdapter.fromJsonTree(jsonElement);
                }
            }.nullSafe();
        }
    }
}

