/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.models;

import com.google.gson.annotations.SerializedName;
import io.kubernetes.client.openapi.models.V1alpha3DeviceSelector;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="DeviceRequest is a request for devices required for a claim. This is typically a request for a single resource like a device, but can also ask for several identical devices.  A DeviceClassName is currently required. Clients must check that it is indeed set. It's absence indicates that something changed in a way that is not supported by the client yet, in which case it must refuse to handle the request.")
public class V1alpha3DeviceRequest {
    public static final String SERIALIZED_NAME_ADMIN_ACCESS = "adminAccess";
    @SerializedName(value="adminAccess")
    private Boolean adminAccess;
    public static final String SERIALIZED_NAME_ALLOCATION_MODE = "allocationMode";
    @SerializedName(value="allocationMode")
    private String allocationMode;
    public static final String SERIALIZED_NAME_COUNT = "count";
    @SerializedName(value="count")
    private Long count;
    public static final String SERIALIZED_NAME_DEVICE_CLASS_NAME = "deviceClassName";
    @SerializedName(value="deviceClassName")
    private String deviceClassName;
    public static final String SERIALIZED_NAME_NAME = "name";
    @SerializedName(value="name")
    private String name;
    public static final String SERIALIZED_NAME_SELECTORS = "selectors";
    @SerializedName(value="selectors")
    private List<V1alpha3DeviceSelector> selectors = null;

    public V1alpha3DeviceRequest adminAccess(Boolean adminAccess) {
        this.adminAccess = adminAccess;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="AdminAccess indicates that this is a claim for administrative access to the device(s). Claims with AdminAccess are expected to be used for monitoring or other management services for a device.  They ignore all ordinary claims to the device with respect to access modes and any resource allocations.  This is an alpha field and requires enabling the DRAAdminAccess feature gate. Admin access is disabled if this field is unset or set to false, otherwise it is enabled.")
    public Boolean getAdminAccess() {
        return this.adminAccess;
    }

    public void setAdminAccess(Boolean adminAccess) {
        this.adminAccess = adminAccess;
    }

    public V1alpha3DeviceRequest allocationMode(String allocationMode) {
        this.allocationMode = allocationMode;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="AllocationMode and its related fields define how devices are allocated to satisfy this request. Supported values are:  - ExactCount: This request is for a specific number of devices.   This is the default. The exact number is provided in the   count field.  - All: This request is for all of the matching devices in a pool.   Allocation will fail if some devices are already allocated,   unless adminAccess is requested.  If AlloctionMode is not specified, the default mode is ExactCount. If the mode is ExactCount and count is not specified, the default count is one. Any other requests must specify this field.  More modes may get added in the future. Clients must refuse to handle requests with unknown modes.")
    public String getAllocationMode() {
        return this.allocationMode;
    }

    public void setAllocationMode(String allocationMode) {
        this.allocationMode = allocationMode;
    }

    public V1alpha3DeviceRequest count(Long count) {
        this.count = count;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Count is used only when the count mode is \"ExactCount\". Must be greater than zero. If AllocationMode is ExactCount and this field is not specified, the default is one.")
    public Long getCount() {
        return this.count;
    }

    public void setCount(Long count) {
        this.count = count;
    }

    public V1alpha3DeviceRequest deviceClassName(String deviceClassName) {
        this.deviceClassName = deviceClassName;
        return this;
    }

    @ApiModelProperty(required=true, value="DeviceClassName references a specific DeviceClass, which can define additional configuration and selectors to be inherited by this request.  A class is required. Which classes are available depends on the cluster.  Administrators may use this to restrict which devices may get requested by only installing classes with selectors for permitted devices. If users are free to request anything without restrictions, then administrators can create an empty DeviceClass for users to reference.")
    public String getDeviceClassName() {
        return this.deviceClassName;
    }

    public void setDeviceClassName(String deviceClassName) {
        this.deviceClassName = deviceClassName;
    }

    public V1alpha3DeviceRequest name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(required=true, value="Name can be used to reference this request in a pod.spec.containers[].resources.claims entry and in a constraint of the claim.  Must be a DNS label.")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public V1alpha3DeviceRequest selectors(List<V1alpha3DeviceSelector> selectors) {
        this.selectors = selectors;
        return this;
    }

    public V1alpha3DeviceRequest addSelectorsItem(V1alpha3DeviceSelector selectorsItem) {
        if (this.selectors == null) {
            this.selectors = new ArrayList<V1alpha3DeviceSelector>();
        }
        this.selectors.add(selectorsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Selectors define criteria which must be satisfied by a specific device in order for that device to be considered for this request. All selectors must be satisfied for a device to be considered.")
    public List<V1alpha3DeviceSelector> getSelectors() {
        return this.selectors;
    }

    public void setSelectors(List<V1alpha3DeviceSelector> selectors) {
        this.selectors = selectors;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V1alpha3DeviceRequest v1alpha3DeviceRequest = (V1alpha3DeviceRequest)o;
        return Objects.equals(this.adminAccess, v1alpha3DeviceRequest.adminAccess) && Objects.equals(this.allocationMode, v1alpha3DeviceRequest.allocationMode) && Objects.equals(this.count, v1alpha3DeviceRequest.count) && Objects.equals(this.deviceClassName, v1alpha3DeviceRequest.deviceClassName) && Objects.equals(this.name, v1alpha3DeviceRequest.name) && Objects.equals(this.selectors, v1alpha3DeviceRequest.selectors);
    }

    public int hashCode() {
        return Objects.hash(this.adminAccess, this.allocationMode, this.count, this.deviceClassName, this.name, this.selectors);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class V1alpha3DeviceRequest {\n");
        sb.append("    adminAccess: ").append(this.toIndentedString(this.adminAccess)).append("\n");
        sb.append("    allocationMode: ").append(this.toIndentedString(this.allocationMode)).append("\n");
        sb.append("    count: ").append(this.toIndentedString(this.count)).append("\n");
        sb.append("    deviceClassName: ").append(this.toIndentedString(this.deviceClassName)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    selectors: ").append(this.toIndentedString(this.selectors)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

