/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.models;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.kubernetes.client.openapi.JSON;
import io.kubernetes.client.openapi.models.V1ExemptPriorityLevelConfiguration;
import io.kubernetes.client.openapi.models.V1LimitedPriorityLevelConfiguration;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.io.IOException;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

@ApiModel(description="PriorityLevelConfigurationSpec specifies the configuration of a priority level.")
public class V1PriorityLevelConfigurationSpec {
    public static final String SERIALIZED_NAME_EXEMPT = "exempt";
    @SerializedName(value="exempt")
    private V1ExemptPriorityLevelConfiguration exempt;
    public static final String SERIALIZED_NAME_LIMITED = "limited";
    @SerializedName(value="limited")
    private V1LimitedPriorityLevelConfiguration limited;
    public static final String SERIALIZED_NAME_TYPE = "type";
    @SerializedName(value="type")
    private String type;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public V1PriorityLevelConfigurationSpec exempt(V1ExemptPriorityLevelConfiguration exempt) {
        this.exempt = exempt;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public V1ExemptPriorityLevelConfiguration getExempt() {
        return this.exempt;
    }

    public void setExempt(V1ExemptPriorityLevelConfiguration exempt) {
        this.exempt = exempt;
    }

    public V1PriorityLevelConfigurationSpec limited(V1LimitedPriorityLevelConfiguration limited) {
        this.limited = limited;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public V1LimitedPriorityLevelConfiguration getLimited() {
        return this.limited;
    }

    public void setLimited(V1LimitedPriorityLevelConfiguration limited) {
        this.limited = limited;
    }

    public V1PriorityLevelConfigurationSpec type(String type) {
        this.type = type;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="`type` indicates whether this priority level is subject to limitation on request execution.  A value of `\"Exempt\"` means that requests of this priority level are not subject to a limit (and thus are never queued) and do not detract from the capacity made available to other priority levels.  A value of `\"Limited\"` means that (a) requests of this priority level _are_ subject to limits and (b) some of the server's limited capacity is made available exclusively to this priority level. Required.")
    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V1PriorityLevelConfigurationSpec v1PriorityLevelConfigurationSpec = (V1PriorityLevelConfigurationSpec)o;
        return Objects.equals(this.exempt, v1PriorityLevelConfigurationSpec.exempt) && Objects.equals(this.limited, v1PriorityLevelConfigurationSpec.limited) && Objects.equals(this.type, v1PriorityLevelConfigurationSpec.type);
    }

    public int hashCode() {
        return Objects.hash(this.exempt, this.limited, this.type);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class V1PriorityLevelConfigurationSpec {\n");
        sb.append("    exempt: ").append(this.toIndentedString(this.exempt)).append("\n");
        sb.append("    limited: ").append(this.toIndentedString(this.limited)).append("\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonElement(JsonElement jsonElement) throws IOException {
        if (jsonElement == null && !openapiRequiredFields.isEmpty()) {
            throw new IllegalArgumentException(String.format("The required field(s) %s in V1PriorityLevelConfigurationSpec is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        Set entries = jsonElement.getAsJsonObject().entrySet();
        for (Map.Entry entry : entries) {
            if (openapiFields.contains(entry.getKey())) continue;
            throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `V1PriorityLevelConfigurationSpec` properties. JSON: %s", entry.getKey(), jsonElement.toString()));
        }
        for (String requiredField : openapiRequiredFields) {
            if (jsonElement.getAsJsonObject().get(requiredField) != null) continue;
            throw new IllegalArgumentException(String.format("The required field `%s` is not found in the JSON string: %s", requiredField, jsonElement.toString()));
        }
        JsonObject jsonObj = jsonElement.getAsJsonObject();
        if (jsonObj.get(SERIALIZED_NAME_EXEMPT) != null && !jsonObj.get(SERIALIZED_NAME_EXEMPT).isJsonNull()) {
            V1ExemptPriorityLevelConfiguration.validateJsonElement(jsonObj.get(SERIALIZED_NAME_EXEMPT));
        }
        if (jsonObj.get(SERIALIZED_NAME_LIMITED) != null && !jsonObj.get(SERIALIZED_NAME_LIMITED).isJsonNull()) {
            V1LimitedPriorityLevelConfiguration.validateJsonElement(jsonObj.get(SERIALIZED_NAME_LIMITED));
        }
        if (!jsonObj.get(SERIALIZED_NAME_TYPE).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `type` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_TYPE).toString()));
        }
    }

    public static V1PriorityLevelConfigurationSpec fromJson(String jsonString) throws IOException {
        return (V1PriorityLevelConfigurationSpec)JSON.getGson().fromJson(jsonString, V1PriorityLevelConfigurationSpec.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_EXEMPT);
        openapiFields.add(SERIALIZED_NAME_LIMITED);
        openapiFields.add(SERIALIZED_NAME_TYPE);
        openapiRequiredFields = new HashSet();
        openapiRequiredFields.add(SERIALIZED_NAME_TYPE);
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!V1PriorityLevelConfigurationSpec.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(V1PriorityLevelConfigurationSpec.class));
            return new TypeAdapter<V1PriorityLevelConfigurationSpec>(){

                public void write(JsonWriter out, V1PriorityLevelConfigurationSpec value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    elementAdapter.write(out, (Object)obj);
                }

                public V1PriorityLevelConfigurationSpec read(JsonReader in) throws IOException {
                    JsonElement jsonElement = (JsonElement)elementAdapter.read(in);
                    V1PriorityLevelConfigurationSpec.validateJsonElement(jsonElement);
                    return (V1PriorityLevelConfigurationSpec)thisAdapter.fromJsonTree(jsonElement);
                }
            }.nullSafe();
        }
    }
}

