/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.models;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.kubernetes.client.openapi.JSON;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import jakarta.annotation.Nullable;
import java.io.IOException;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

@ApiModel(description="ListMeta describes metadata that synthetic resources must have, including lists and various status objects. A resource may have only one of {ObjectMeta, ListMeta}.")
public class V1ListMeta {
    public static final String SERIALIZED_NAME_CONTINUE = "continue";
    @SerializedName(value="continue")
    private String _continue;
    public static final String SERIALIZED_NAME_REMAINING_ITEM_COUNT = "remainingItemCount";
    @SerializedName(value="remainingItemCount")
    private Long remainingItemCount;
    public static final String SERIALIZED_NAME_RESOURCE_VERSION = "resourceVersion";
    @SerializedName(value="resourceVersion")
    private String resourceVersion;
    public static final String SERIALIZED_NAME_SELF_LINK = "selfLink";
    @SerializedName(value="selfLink")
    private String selfLink;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public V1ListMeta _continue(String _continue) {
        this._continue = _continue;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="continue may be set if the user set a limit on the number of items returned, and indicates that the server has more data available. The value is opaque and may be used to issue another request to the endpoint that served this list to retrieve the next set of available objects. Continuing a consistent list may not be possible if the server configuration has changed or more than a few minutes have passed. The resourceVersion field returned when using this continue value will be identical to the value in the first response, unless you have received this token from an error message.")
    public String getContinue() {
        return this._continue;
    }

    public void setContinue(String _continue) {
        this._continue = _continue;
    }

    public V1ListMeta remainingItemCount(Long remainingItemCount) {
        this.remainingItemCount = remainingItemCount;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="remainingItemCount is the number of subsequent items in the list which are not included in this list response. If the list request contained label or field selectors, then the number of remaining items is unknown and the field will be left unset and omitted during serialization. If the list is complete (either because it is not chunking or because this is the last chunk), then there are no more remaining items and this field will be left unset and omitted during serialization. Servers older than v1.15 do not set this field. The intended use of the remainingItemCount is *estimating* the size of a collection. Clients should not rely on the remainingItemCount to be set or to be exact.")
    public Long getRemainingItemCount() {
        return this.remainingItemCount;
    }

    public void setRemainingItemCount(Long remainingItemCount) {
        this.remainingItemCount = remainingItemCount;
    }

    public V1ListMeta resourceVersion(String resourceVersion) {
        this.resourceVersion = resourceVersion;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="String that identifies the server's internal version of this object that can be used by clients to determine when objects have changed. Value must be treated as opaque by clients and passed unmodified back to the server. Populated by the system. Read-only. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#concurrency-control-and-consistency")
    public String getResourceVersion() {
        return this.resourceVersion;
    }

    public void setResourceVersion(String resourceVersion) {
        this.resourceVersion = resourceVersion;
    }

    public V1ListMeta selfLink(String selfLink) {
        this.selfLink = selfLink;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Deprecated: selfLink is a legacy read-only field that is no longer populated by the system.")
    public String getSelfLink() {
        return this.selfLink;
    }

    public void setSelfLink(String selfLink) {
        this.selfLink = selfLink;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V1ListMeta v1ListMeta = (V1ListMeta)o;
        return Objects.equals(this._continue, v1ListMeta._continue) && Objects.equals(this.remainingItemCount, v1ListMeta.remainingItemCount) && Objects.equals(this.resourceVersion, v1ListMeta.resourceVersion) && Objects.equals(this.selfLink, v1ListMeta.selfLink);
    }

    public int hashCode() {
        return Objects.hash(this._continue, this.remainingItemCount, this.resourceVersion, this.selfLink);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class V1ListMeta {\n");
        sb.append("    _continue: ").append(this.toIndentedString(this._continue)).append("\n");
        sb.append("    remainingItemCount: ").append(this.toIndentedString(this.remainingItemCount)).append("\n");
        sb.append("    resourceVersion: ").append(this.toIndentedString(this.resourceVersion)).append("\n");
        sb.append("    selfLink: ").append(this.toIndentedString(this.selfLink)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonElement(JsonElement jsonElement) throws IOException {
        if (jsonElement == null && !openapiRequiredFields.isEmpty()) {
            throw new IllegalArgumentException(String.format("The required field(s) %s in V1ListMeta is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        Set entries = jsonElement.getAsJsonObject().entrySet();
        for (Map.Entry entry : entries) {
            if (openapiFields.contains(entry.getKey())) continue;
            throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `V1ListMeta` properties. JSON: %s", entry.getKey(), jsonElement.toString()));
        }
        JsonObject jsonObj = jsonElement.getAsJsonObject();
        if (jsonObj.get(SERIALIZED_NAME_CONTINUE) != null && !jsonObj.get(SERIALIZED_NAME_CONTINUE).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_CONTINUE).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `continue` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_CONTINUE).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_RESOURCE_VERSION) != null && !jsonObj.get(SERIALIZED_NAME_RESOURCE_VERSION).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_RESOURCE_VERSION).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `resourceVersion` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_RESOURCE_VERSION).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_SELF_LINK) != null && !jsonObj.get(SERIALIZED_NAME_SELF_LINK).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_SELF_LINK).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `selfLink` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_SELF_LINK).toString()));
        }
    }

    public static V1ListMeta fromJson(String jsonString) throws IOException {
        return (V1ListMeta)JSON.getGson().fromJson(jsonString, V1ListMeta.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_CONTINUE);
        openapiFields.add(SERIALIZED_NAME_REMAINING_ITEM_COUNT);
        openapiFields.add(SERIALIZED_NAME_RESOURCE_VERSION);
        openapiFields.add(SERIALIZED_NAME_SELF_LINK);
        openapiRequiredFields = new HashSet();
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!V1ListMeta.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(V1ListMeta.class));
            return new TypeAdapter<V1ListMeta>(){

                public void write(JsonWriter out, V1ListMeta value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    elementAdapter.write(out, (Object)obj);
                }

                public V1ListMeta read(JsonReader in) throws IOException {
                    JsonElement jsonElement = (JsonElement)elementAdapter.read(in);
                    return (V1ListMeta)thisAdapter.fromJsonTree(jsonElement);
                }
            }.nullSafe();
        }
    }
}

