/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.custom;

import io.kubernetes.client.custom.BaseExponent;
import io.kubernetes.client.custom.Quantity;
import io.kubernetes.client.custom.QuantityFormatException;
import io.kubernetes.client.custom.SuffixFormatter;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.MathContext;
import org.apache.commons.lang3.tuple.Pair;

public class QuantityFormatter {
    private static final String PARTS_RE = "[eEinumkKMGTP]+";

    public Quantity parse(String value) {
        if (value == null || value.isEmpty()) {
            throw new QuantityFormatException("");
        }
        String[] parts = value.split(PARTS_RE);
        BigDecimal numericValue = QuantityFormatter.parseNumericValue(parts[0]);
        String suffix = value.substring(parts[0].length());
        BaseExponent baseExponent = new SuffixFormatter().parse(suffix);
        BigDecimal unitMultiplier = BigDecimal.valueOf(baseExponent.getBase()).pow(baseExponent.getExponent(), MathContext.DECIMAL64);
        BigDecimal unitlessValue = numericValue.multiply(unitMultiplier);
        return new Quantity(unitlessValue, baseExponent.getFormat());
    }

    private static BigDecimal parseNumericValue(String part) {
        try {
            return new BigDecimal(part);
        }
        catch (NumberFormatException e) {
            throw new QuantityFormatException("Unable to parse numeric part of quantity: " + part);
        }
    }

    public String format(Quantity quantity) {
        switch (quantity.getFormat()) {
            case DECIMAL_SI: 
            case DECIMAL_EXPONENT: {
                return this.toBase10String(quantity);
            }
            case BINARY_SI: {
                if (this.isFractional(quantity)) {
                    return this.toBase10String(new Quantity(quantity.getNumber(), Quantity.Format.DECIMAL_SI));
                }
                return this.toBase1024String(quantity);
            }
        }
        throw new IllegalArgumentException("Can't format a " + String.valueOf((Object)quantity.getFormat()) + " quantity");
    }

    private boolean isFractional(Quantity quantity) {
        return quantity.getNumber().scale() > 0;
    }

    private String toBase1024String(Quantity quantity) {
        BigDecimal amount = quantity.getNumber();
        BigInteger value = amount.unscaledValue();
        int exponent = -amount.scale();
        Pair<BigInteger, Integer> resultAndTimes = this.removeFactorsForBase(value, BigInteger.valueOf(1024L));
        return String.valueOf(resultAndTimes.getLeft()) + new SuffixFormatter().format(quantity.getFormat(), exponent + (Integer)resultAndTimes.getRight() * 10);
    }

    private String toBase10String(Quantity quantity) {
        BigDecimal amount = quantity.getNumber();
        BigInteger value = amount.unscaledValue();
        int exponent = -amount.scale();
        Pair<BigInteger, Integer> resultAndTimes = this.removeFactorsForBase(value, BigInteger.TEN);
        int postFactoringExponent = exponent + (Integer)resultAndTimes.getRight();
        Pair<BigInteger, Integer> valueAndExponent = this.ensureExponentIsMultipleOf3((BigInteger)resultAndTimes.getLeft(), postFactoringExponent);
        return String.valueOf(valueAndExponent.getLeft()) + new SuffixFormatter().format(quantity.getFormat(), (Integer)valueAndExponent.getRight());
    }

    private Pair<BigInteger, Integer> ensureExponentIsMultipleOf3(BigInteger mantissa, int exponent) {
        long exponentRemainder = exponent % 3;
        if (exponentRemainder == 1L || exponentRemainder == -2L) {
            return Pair.of((Object)mantissa.multiply(BigInteger.TEN), (Object)(exponent - 1));
        }
        if (exponentRemainder == -1L || exponentRemainder == 2L) {
            return Pair.of((Object)mantissa.multiply(BigInteger.valueOf(100L)), (Object)(exponent - 2));
        }
        return Pair.of((Object)mantissa, (Object)exponent);
    }

    private Pair<BigInteger, Integer> removeFactorsForBase(BigInteger value, BigInteger base) {
        int times = 0;
        BigInteger result = value;
        while (result.compareTo(base) >= 0 && result.mod(base).equals(BigInteger.ZERO)) {
            ++times;
            result = result.divide(base);
        }
        return Pair.of((Object)result, (Object)times);
    }
}

