/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.models;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="LinuxContainerUser represents user identity information in Linux containers")
public class V1LinuxContainerUser {
    public static final String SERIALIZED_NAME_GID = "gid";
    @SerializedName(value="gid")
    private Long gid;
    public static final String SERIALIZED_NAME_SUPPLEMENTAL_GROUPS = "supplementalGroups";
    @SerializedName(value="supplementalGroups")
    private List<Long> supplementalGroups = null;
    public static final String SERIALIZED_NAME_UID = "uid";
    @SerializedName(value="uid")
    private Long uid;

    public V1LinuxContainerUser gid(Long gid) {
        this.gid = gid;
        return this;
    }

    @ApiModelProperty(required=true, value="GID is the primary gid initially attached to the first process in the container")
    public Long getGid() {
        return this.gid;
    }

    public void setGid(Long gid) {
        this.gid = gid;
    }

    public V1LinuxContainerUser supplementalGroups(List<Long> supplementalGroups) {
        this.supplementalGroups = supplementalGroups;
        return this;
    }

    public V1LinuxContainerUser addSupplementalGroupsItem(Long supplementalGroupsItem) {
        if (this.supplementalGroups == null) {
            this.supplementalGroups = new ArrayList<Long>();
        }
        this.supplementalGroups.add(supplementalGroupsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="SupplementalGroups are the supplemental groups initially attached to the first process in the container")
    public List<Long> getSupplementalGroups() {
        return this.supplementalGroups;
    }

    public void setSupplementalGroups(List<Long> supplementalGroups) {
        this.supplementalGroups = supplementalGroups;
    }

    public V1LinuxContainerUser uid(Long uid) {
        this.uid = uid;
        return this;
    }

    @ApiModelProperty(required=true, value="UID is the primary uid initially attached to the first process in the container")
    public Long getUid() {
        return this.uid;
    }

    public void setUid(Long uid) {
        this.uid = uid;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V1LinuxContainerUser v1LinuxContainerUser = (V1LinuxContainerUser)o;
        return Objects.equals(this.gid, v1LinuxContainerUser.gid) && Objects.equals(this.supplementalGroups, v1LinuxContainerUser.supplementalGroups) && Objects.equals(this.uid, v1LinuxContainerUser.uid);
    }

    public int hashCode() {
        return Objects.hash(this.gid, this.supplementalGroups, this.uid);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class V1LinuxContainerUser {\n");
        sb.append("    gid: ").append(this.toIndentedString(this.gid)).append("\n");
        sb.append("    supplementalGroups: ").append(this.toIndentedString(this.supplementalGroups)).append("\n");
        sb.append("    uid: ").append(this.toIndentedString(this.uid)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

