/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.models;

import com.google.gson.annotations.SerializedName;
import io.kubernetes.client.openapi.models.V1alpha2DriverAllocationResult;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="StructuredResourceHandle is the in-tree representation of the allocation result.")
public class V1alpha2StructuredResourceHandle {
    public static final String SERIALIZED_NAME_NODE_NAME = "nodeName";
    @SerializedName(value="nodeName")
    private String nodeName;
    public static final String SERIALIZED_NAME_RESULTS = "results";
    @SerializedName(value="results")
    private List<V1alpha2DriverAllocationResult> results = new ArrayList<V1alpha2DriverAllocationResult>();
    public static final String SERIALIZED_NAME_VENDOR_CLAIM_PARAMETERS = "vendorClaimParameters";
    @SerializedName(value="vendorClaimParameters")
    private Object vendorClaimParameters;
    public static final String SERIALIZED_NAME_VENDOR_CLASS_PARAMETERS = "vendorClassParameters";
    @SerializedName(value="vendorClassParameters")
    private Object vendorClassParameters;

    public V1alpha2StructuredResourceHandle nodeName(String nodeName) {
        this.nodeName = nodeName;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="NodeName is the name of the node providing the necessary resources if the resources are local to a node.")
    public String getNodeName() {
        return this.nodeName;
    }

    public void setNodeName(String nodeName) {
        this.nodeName = nodeName;
    }

    public V1alpha2StructuredResourceHandle results(List<V1alpha2DriverAllocationResult> results) {
        this.results = results;
        return this;
    }

    public V1alpha2StructuredResourceHandle addResultsItem(V1alpha2DriverAllocationResult resultsItem) {
        this.results.add(resultsItem);
        return this;
    }

    @ApiModelProperty(required=true, value="Results lists all allocated driver resources.")
    public List<V1alpha2DriverAllocationResult> getResults() {
        return this.results;
    }

    public void setResults(List<V1alpha2DriverAllocationResult> results) {
        this.results = results;
    }

    public V1alpha2StructuredResourceHandle vendorClaimParameters(Object vendorClaimParameters) {
        this.vendorClaimParameters = vendorClaimParameters;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="VendorClaimParameters are the per-claim configuration parameters from the resource claim parameters at the time that the claim was allocated.")
    public Object getVendorClaimParameters() {
        return this.vendorClaimParameters;
    }

    public void setVendorClaimParameters(Object vendorClaimParameters) {
        this.vendorClaimParameters = vendorClaimParameters;
    }

    public V1alpha2StructuredResourceHandle vendorClassParameters(Object vendorClassParameters) {
        this.vendorClassParameters = vendorClassParameters;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="VendorClassParameters are the per-claim configuration parameters from the resource class at the time that the claim was allocated.")
    public Object getVendorClassParameters() {
        return this.vendorClassParameters;
    }

    public void setVendorClassParameters(Object vendorClassParameters) {
        this.vendorClassParameters = vendorClassParameters;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V1alpha2StructuredResourceHandle v1alpha2StructuredResourceHandle = (V1alpha2StructuredResourceHandle)o;
        return Objects.equals(this.nodeName, v1alpha2StructuredResourceHandle.nodeName) && Objects.equals(this.results, v1alpha2StructuredResourceHandle.results) && Objects.equals(this.vendorClaimParameters, v1alpha2StructuredResourceHandle.vendorClaimParameters) && Objects.equals(this.vendorClassParameters, v1alpha2StructuredResourceHandle.vendorClassParameters);
    }

    public int hashCode() {
        return Objects.hash(this.nodeName, this.results, this.vendorClaimParameters, this.vendorClassParameters);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class V1alpha2StructuredResourceHandle {\n");
        sb.append("    nodeName: ").append(this.toIndentedString(this.nodeName)).append("\n");
        sb.append("    results: ").append(this.toIndentedString(this.results)).append("\n");
        sb.append("    vendorClaimParameters: ").append(this.toIndentedString(this.vendorClaimParameters)).append("\n");
        sb.append("    vendorClassParameters: ").append(this.toIndentedString(this.vendorClassParameters)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

