/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.models;

import com.google.gson.annotations.SerializedName;
import io.kubernetes.client.openapi.models.V1CustomResourceColumnDefinition;
import io.kubernetes.client.openapi.models.V1CustomResourceSubresources;
import io.kubernetes.client.openapi.models.V1CustomResourceValidation;
import io.kubernetes.client.openapi.models.V1SelectableField;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="CustomResourceDefinitionVersion describes a version for CRD.")
public class V1CustomResourceDefinitionVersion {
    public static final String SERIALIZED_NAME_ADDITIONAL_PRINTER_COLUMNS = "additionalPrinterColumns";
    @SerializedName(value="additionalPrinterColumns")
    private List<V1CustomResourceColumnDefinition> additionalPrinterColumns = null;
    public static final String SERIALIZED_NAME_DEPRECATED = "deprecated";
    @SerializedName(value="deprecated")
    private Boolean deprecated;
    public static final String SERIALIZED_NAME_DEPRECATION_WARNING = "deprecationWarning";
    @SerializedName(value="deprecationWarning")
    private String deprecationWarning;
    public static final String SERIALIZED_NAME_NAME = "name";
    @SerializedName(value="name")
    private String name;
    public static final String SERIALIZED_NAME_SCHEMA = "schema";
    @SerializedName(value="schema")
    private V1CustomResourceValidation schema;
    public static final String SERIALIZED_NAME_SELECTABLE_FIELDS = "selectableFields";
    @SerializedName(value="selectableFields")
    private List<V1SelectableField> selectableFields = null;
    public static final String SERIALIZED_NAME_SERVED = "served";
    @SerializedName(value="served")
    private Boolean served;
    public static final String SERIALIZED_NAME_STORAGE = "storage";
    @SerializedName(value="storage")
    private Boolean storage;
    public static final String SERIALIZED_NAME_SUBRESOURCES = "subresources";
    @SerializedName(value="subresources")
    private V1CustomResourceSubresources subresources;

    public V1CustomResourceDefinitionVersion additionalPrinterColumns(List<V1CustomResourceColumnDefinition> additionalPrinterColumns) {
        this.additionalPrinterColumns = additionalPrinterColumns;
        return this;
    }

    public V1CustomResourceDefinitionVersion addAdditionalPrinterColumnsItem(V1CustomResourceColumnDefinition additionalPrinterColumnsItem) {
        if (this.additionalPrinterColumns == null) {
            this.additionalPrinterColumns = new ArrayList<V1CustomResourceColumnDefinition>();
        }
        this.additionalPrinterColumns.add(additionalPrinterColumnsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="additionalPrinterColumns specifies additional columns returned in Table output. See https://kubernetes.io/docs/reference/using-api/api-concepts/#receiving-resources-as-tables for details. If no columns are specified, a single column displaying the age of the custom resource is used.")
    public List<V1CustomResourceColumnDefinition> getAdditionalPrinterColumns() {
        return this.additionalPrinterColumns;
    }

    public void setAdditionalPrinterColumns(List<V1CustomResourceColumnDefinition> additionalPrinterColumns) {
        this.additionalPrinterColumns = additionalPrinterColumns;
    }

    public V1CustomResourceDefinitionVersion deprecated(Boolean deprecated) {
        this.deprecated = deprecated;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="deprecated indicates this version of the custom resource API is deprecated. When set to true, API requests to this version receive a warning header in the server response. Defaults to false.")
    public Boolean getDeprecated() {
        return this.deprecated;
    }

    public void setDeprecated(Boolean deprecated) {
        this.deprecated = deprecated;
    }

    public V1CustomResourceDefinitionVersion deprecationWarning(String deprecationWarning) {
        this.deprecationWarning = deprecationWarning;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="deprecationWarning overrides the default warning returned to API clients. May only be set when `deprecated` is true. The default warning indicates this version is deprecated and recommends use of the newest served version of equal or greater stability, if one exists.")
    public String getDeprecationWarning() {
        return this.deprecationWarning;
    }

    public void setDeprecationWarning(String deprecationWarning) {
        this.deprecationWarning = deprecationWarning;
    }

    public V1CustomResourceDefinitionVersion name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(required=true, value="name is the version name, e.g. \u201cv1\u201d, \u201cv2beta1\u201d, etc. The custom resources are served under this version at `/apis/<group>/<version>/...` if `served` is true.")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public V1CustomResourceDefinitionVersion schema(V1CustomResourceValidation schema) {
        this.schema = schema;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public V1CustomResourceValidation getSchema() {
        return this.schema;
    }

    public void setSchema(V1CustomResourceValidation schema) {
        this.schema = schema;
    }

    public V1CustomResourceDefinitionVersion selectableFields(List<V1SelectableField> selectableFields) {
        this.selectableFields = selectableFields;
        return this;
    }

    public V1CustomResourceDefinitionVersion addSelectableFieldsItem(V1SelectableField selectableFieldsItem) {
        if (this.selectableFields == null) {
            this.selectableFields = new ArrayList<V1SelectableField>();
        }
        this.selectableFields.add(selectableFieldsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="selectableFields specifies paths to fields that may be used as field selectors. A maximum of 8 selectable fields are allowed. See https://kubernetes.io/docs/concepts/overview/working-with-objects/field-selectors")
    public List<V1SelectableField> getSelectableFields() {
        return this.selectableFields;
    }

    public void setSelectableFields(List<V1SelectableField> selectableFields) {
        this.selectableFields = selectableFields;
    }

    public V1CustomResourceDefinitionVersion served(Boolean served) {
        this.served = served;
        return this;
    }

    @ApiModelProperty(required=true, value="served is a flag enabling/disabling this version from being served via REST APIs")
    public Boolean getServed() {
        return this.served;
    }

    public void setServed(Boolean served) {
        this.served = served;
    }

    public V1CustomResourceDefinitionVersion storage(Boolean storage) {
        this.storage = storage;
        return this;
    }

    @ApiModelProperty(required=true, value="storage indicates this version should be used when persisting custom resources to storage. There must be exactly one version with storage=true.")
    public Boolean getStorage() {
        return this.storage;
    }

    public void setStorage(Boolean storage) {
        this.storage = storage;
    }

    public V1CustomResourceDefinitionVersion subresources(V1CustomResourceSubresources subresources) {
        this.subresources = subresources;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public V1CustomResourceSubresources getSubresources() {
        return this.subresources;
    }

    public void setSubresources(V1CustomResourceSubresources subresources) {
        this.subresources = subresources;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V1CustomResourceDefinitionVersion v1CustomResourceDefinitionVersion = (V1CustomResourceDefinitionVersion)o;
        return Objects.equals(this.additionalPrinterColumns, v1CustomResourceDefinitionVersion.additionalPrinterColumns) && Objects.equals(this.deprecated, v1CustomResourceDefinitionVersion.deprecated) && Objects.equals(this.deprecationWarning, v1CustomResourceDefinitionVersion.deprecationWarning) && Objects.equals(this.name, v1CustomResourceDefinitionVersion.name) && Objects.equals(this.schema, v1CustomResourceDefinitionVersion.schema) && Objects.equals(this.selectableFields, v1CustomResourceDefinitionVersion.selectableFields) && Objects.equals(this.served, v1CustomResourceDefinitionVersion.served) && Objects.equals(this.storage, v1CustomResourceDefinitionVersion.storage) && Objects.equals(this.subresources, v1CustomResourceDefinitionVersion.subresources);
    }

    public int hashCode() {
        return Objects.hash(this.additionalPrinterColumns, this.deprecated, this.deprecationWarning, this.name, this.schema, this.selectableFields, this.served, this.storage, this.subresources);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class V1CustomResourceDefinitionVersion {\n");
        sb.append("    additionalPrinterColumns: ").append(this.toIndentedString(this.additionalPrinterColumns)).append("\n");
        sb.append("    deprecated: ").append(this.toIndentedString(this.deprecated)).append("\n");
        sb.append("    deprecationWarning: ").append(this.toIndentedString(this.deprecationWarning)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    schema: ").append(this.toIndentedString(this.schema)).append("\n");
        sb.append("    selectableFields: ").append(this.toIndentedString(this.selectableFields)).append("\n");
        sb.append("    served: ").append(this.toIndentedString(this.served)).append("\n");
        sb.append("    storage: ").append(this.toIndentedString(this.storage)).append("\n");
        sb.append("    subresources: ").append(this.toIndentedString(this.subresources)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

