/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.models;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.kubernetes.client.openapi.JSON;
import io.kubernetes.client.openapi.models.V1JobCondition;
import io.kubernetes.client.openapi.models.V1UncountedTerminatedPods;
import jakarta.annotation.Nullable;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public class V1JobStatus {
    public static final String SERIALIZED_NAME_ACTIVE = "active";
    @SerializedName(value="active")
    private Integer active;
    public static final String SERIALIZED_NAME_COMPLETED_INDEXES = "completedIndexes";
    @SerializedName(value="completedIndexes")
    private String completedIndexes;
    public static final String SERIALIZED_NAME_COMPLETION_TIME = "completionTime";
    @SerializedName(value="completionTime")
    private OffsetDateTime completionTime;
    public static final String SERIALIZED_NAME_CONDITIONS = "conditions";
    @SerializedName(value="conditions")
    private List<V1JobCondition> conditions;
    public static final String SERIALIZED_NAME_FAILED = "failed";
    @SerializedName(value="failed")
    private Integer failed;
    public static final String SERIALIZED_NAME_FAILED_INDEXES = "failedIndexes";
    @SerializedName(value="failedIndexes")
    private String failedIndexes;
    public static final String SERIALIZED_NAME_READY = "ready";
    @SerializedName(value="ready")
    private Integer ready;
    public static final String SERIALIZED_NAME_START_TIME = "startTime";
    @SerializedName(value="startTime")
    private OffsetDateTime startTime;
    public static final String SERIALIZED_NAME_SUCCEEDED = "succeeded";
    @SerializedName(value="succeeded")
    private Integer succeeded;
    public static final String SERIALIZED_NAME_TERMINATING = "terminating";
    @SerializedName(value="terminating")
    private Integer terminating;
    public static final String SERIALIZED_NAME_UNCOUNTED_TERMINATED_PODS = "uncountedTerminatedPods";
    @SerializedName(value="uncountedTerminatedPods")
    private V1UncountedTerminatedPods uncountedTerminatedPods;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public V1JobStatus active(Integer active) {
        this.active = active;
        return this;
    }

    @Nullable
    public Integer getActive() {
        return this.active;
    }

    public void setActive(Integer active) {
        this.active = active;
    }

    public V1JobStatus completedIndexes(String completedIndexes) {
        this.completedIndexes = completedIndexes;
        return this;
    }

    @Nullable
    public String getCompletedIndexes() {
        return this.completedIndexes;
    }

    public void setCompletedIndexes(String completedIndexes) {
        this.completedIndexes = completedIndexes;
    }

    public V1JobStatus completionTime(OffsetDateTime completionTime) {
        this.completionTime = completionTime;
        return this;
    }

    @Nullable
    public OffsetDateTime getCompletionTime() {
        return this.completionTime;
    }

    public void setCompletionTime(OffsetDateTime completionTime) {
        this.completionTime = completionTime;
    }

    public V1JobStatus conditions(List<V1JobCondition> conditions) {
        this.conditions = conditions;
        return this;
    }

    public V1JobStatus addConditionsItem(V1JobCondition conditionsItem) {
        if (this.conditions == null) {
            this.conditions = new ArrayList<V1JobCondition>();
        }
        this.conditions.add(conditionsItem);
        return this;
    }

    @Nullable
    public List<V1JobCondition> getConditions() {
        return this.conditions;
    }

    public void setConditions(List<V1JobCondition> conditions) {
        this.conditions = conditions;
    }

    public V1JobStatus failed(Integer failed) {
        this.failed = failed;
        return this;
    }

    @Nullable
    public Integer getFailed() {
        return this.failed;
    }

    public void setFailed(Integer failed) {
        this.failed = failed;
    }

    public V1JobStatus failedIndexes(String failedIndexes) {
        this.failedIndexes = failedIndexes;
        return this;
    }

    @Nullable
    public String getFailedIndexes() {
        return this.failedIndexes;
    }

    public void setFailedIndexes(String failedIndexes) {
        this.failedIndexes = failedIndexes;
    }

    public V1JobStatus ready(Integer ready) {
        this.ready = ready;
        return this;
    }

    @Nullable
    public Integer getReady() {
        return this.ready;
    }

    public void setReady(Integer ready) {
        this.ready = ready;
    }

    public V1JobStatus startTime(OffsetDateTime startTime) {
        this.startTime = startTime;
        return this;
    }

    @Nullable
    public OffsetDateTime getStartTime() {
        return this.startTime;
    }

    public void setStartTime(OffsetDateTime startTime) {
        this.startTime = startTime;
    }

    public V1JobStatus succeeded(Integer succeeded) {
        this.succeeded = succeeded;
        return this;
    }

    @Nullable
    public Integer getSucceeded() {
        return this.succeeded;
    }

    public void setSucceeded(Integer succeeded) {
        this.succeeded = succeeded;
    }

    public V1JobStatus terminating(Integer terminating) {
        this.terminating = terminating;
        return this;
    }

    @Nullable
    public Integer getTerminating() {
        return this.terminating;
    }

    public void setTerminating(Integer terminating) {
        this.terminating = terminating;
    }

    public V1JobStatus uncountedTerminatedPods(V1UncountedTerminatedPods uncountedTerminatedPods) {
        this.uncountedTerminatedPods = uncountedTerminatedPods;
        return this;
    }

    @Nullable
    public V1UncountedTerminatedPods getUncountedTerminatedPods() {
        return this.uncountedTerminatedPods;
    }

    public void setUncountedTerminatedPods(V1UncountedTerminatedPods uncountedTerminatedPods) {
        this.uncountedTerminatedPods = uncountedTerminatedPods;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V1JobStatus v1JobStatus = (V1JobStatus)o;
        return Objects.equals(this.active, v1JobStatus.active) && Objects.equals(this.completedIndexes, v1JobStatus.completedIndexes) && Objects.equals(this.completionTime, v1JobStatus.completionTime) && Objects.equals(this.conditions, v1JobStatus.conditions) && Objects.equals(this.failed, v1JobStatus.failed) && Objects.equals(this.failedIndexes, v1JobStatus.failedIndexes) && Objects.equals(this.ready, v1JobStatus.ready) && Objects.equals(this.startTime, v1JobStatus.startTime) && Objects.equals(this.succeeded, v1JobStatus.succeeded) && Objects.equals(this.terminating, v1JobStatus.terminating) && Objects.equals(this.uncountedTerminatedPods, v1JobStatus.uncountedTerminatedPods);
    }

    public int hashCode() {
        return Objects.hash(this.active, this.completedIndexes, this.completionTime, this.conditions, this.failed, this.failedIndexes, this.ready, this.startTime, this.succeeded, this.terminating, this.uncountedTerminatedPods);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class V1JobStatus {\n");
        sb.append("    active: ").append(this.toIndentedString(this.active)).append("\n");
        sb.append("    completedIndexes: ").append(this.toIndentedString(this.completedIndexes)).append("\n");
        sb.append("    completionTime: ").append(this.toIndentedString(this.completionTime)).append("\n");
        sb.append("    conditions: ").append(this.toIndentedString(this.conditions)).append("\n");
        sb.append("    failed: ").append(this.toIndentedString(this.failed)).append("\n");
        sb.append("    failedIndexes: ").append(this.toIndentedString(this.failedIndexes)).append("\n");
        sb.append("    ready: ").append(this.toIndentedString(this.ready)).append("\n");
        sb.append("    startTime: ").append(this.toIndentedString(this.startTime)).append("\n");
        sb.append("    succeeded: ").append(this.toIndentedString(this.succeeded)).append("\n");
        sb.append("    terminating: ").append(this.toIndentedString(this.terminating)).append("\n");
        sb.append("    uncountedTerminatedPods: ").append(this.toIndentedString(this.uncountedTerminatedPods)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonObject(JsonObject jsonObj) throws IOException {
        JsonArray jsonArrayconditions;
        if (jsonObj == null && !openapiRequiredFields.isEmpty()) {
            throw new IllegalArgumentException(String.format("The required field(s) %s in V1JobStatus is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        Set entries = jsonObj.entrySet();
        for (Map.Entry entry : entries) {
            if (openapiFields.contains(entry.getKey())) continue;
            throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `V1JobStatus` properties. JSON: %s", entry.getKey(), jsonObj.toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_COMPLETED_INDEXES) != null && !jsonObj.get(SERIALIZED_NAME_COMPLETED_INDEXES).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_COMPLETED_INDEXES).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `completedIndexes` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_COMPLETED_INDEXES).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_CONDITIONS) != null && !jsonObj.get(SERIALIZED_NAME_CONDITIONS).isJsonNull() && (jsonArrayconditions = jsonObj.getAsJsonArray(SERIALIZED_NAME_CONDITIONS)) != null) {
            if (!jsonObj.get(SERIALIZED_NAME_CONDITIONS).isJsonArray()) {
                throw new IllegalArgumentException(String.format("Expected the field `conditions` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_CONDITIONS).toString()));
            }
            for (int i = 0; i < jsonArrayconditions.size(); ++i) {
                V1JobCondition.validateJsonObject(jsonArrayconditions.get(i).getAsJsonObject());
            }
        }
        if (jsonObj.get(SERIALIZED_NAME_FAILED_INDEXES) != null && !jsonObj.get(SERIALIZED_NAME_FAILED_INDEXES).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_FAILED_INDEXES).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `failedIndexes` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_FAILED_INDEXES).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_UNCOUNTED_TERMINATED_PODS) != null && !jsonObj.get(SERIALIZED_NAME_UNCOUNTED_TERMINATED_PODS).isJsonNull()) {
            V1UncountedTerminatedPods.validateJsonObject(jsonObj.getAsJsonObject(SERIALIZED_NAME_UNCOUNTED_TERMINATED_PODS));
        }
    }

    public static V1JobStatus fromJson(String jsonString) throws IOException {
        return (V1JobStatus)JSON.getGson().fromJson(jsonString, V1JobStatus.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_ACTIVE);
        openapiFields.add(SERIALIZED_NAME_COMPLETED_INDEXES);
        openapiFields.add(SERIALIZED_NAME_COMPLETION_TIME);
        openapiFields.add(SERIALIZED_NAME_CONDITIONS);
        openapiFields.add(SERIALIZED_NAME_FAILED);
        openapiFields.add(SERIALIZED_NAME_FAILED_INDEXES);
        openapiFields.add(SERIALIZED_NAME_READY);
        openapiFields.add(SERIALIZED_NAME_START_TIME);
        openapiFields.add(SERIALIZED_NAME_SUCCEEDED);
        openapiFields.add(SERIALIZED_NAME_TERMINATING);
        openapiFields.add(SERIALIZED_NAME_UNCOUNTED_TERMINATED_PODS);
        openapiRequiredFields = new HashSet();
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!V1JobStatus.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(V1JobStatus.class));
            return new TypeAdapter<V1JobStatus>(){

                public void write(JsonWriter out, V1JobStatus value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    elementAdapter.write(out, (Object)obj);
                }

                public V1JobStatus read(JsonReader in) throws IOException {
                    JsonObject jsonObj = ((JsonElement)elementAdapter.read(in)).getAsJsonObject();
                    V1JobStatus.validateJsonObject(jsonObj);
                    return (V1JobStatus)thisAdapter.fromJsonTree((JsonElement)jsonObj);
                }
            }.nullSafe();
        }
    }
}

