/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.models;

import com.google.gson.annotations.SerializedName;
import io.kubernetes.client.models.V1ListMeta;
import io.kubernetes.client.models.V1StatefulSet;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@ApiModel(description="StatefulSetList is a collection of StatefulSets.")
public class V1StatefulSetList {
    @SerializedName(value="apiVersion")
    private String apiVersion = null;
    @SerializedName(value="items")
    private List<V1StatefulSet> items = new ArrayList<V1StatefulSet>();
    @SerializedName(value="kind")
    private String kind = null;
    @SerializedName(value="metadata")
    private V1ListMeta metadata = null;

    public V1StatefulSetList apiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
        return this;
    }

    @ApiModelProperty(value="APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#resources")
    public String getApiVersion() {
        return this.apiVersion;
    }

    public void setApiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
    }

    public V1StatefulSetList items(List<V1StatefulSet> items) {
        this.items = items;
        return this;
    }

    public V1StatefulSetList addItemsItem(V1StatefulSet itemsItem) {
        this.items.add(itemsItem);
        return this;
    }

    @ApiModelProperty(required=true, value="")
    public List<V1StatefulSet> getItems() {
        return this.items;
    }

    public void setItems(List<V1StatefulSet> items) {
        this.items = items;
    }

    public V1StatefulSetList kind(String kind) {
        this.kind = kind;
        return this;
    }

    @ApiModelProperty(value="Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#types-kinds")
    public String getKind() {
        return this.kind;
    }

    public void setKind(String kind) {
        this.kind = kind;
    }

    public V1StatefulSetList metadata(V1ListMeta metadata) {
        this.metadata = metadata;
        return this;
    }

    @ApiModelProperty(value="")
    public V1ListMeta getMetadata() {
        return this.metadata;
    }

    public void setMetadata(V1ListMeta metadata) {
        this.metadata = metadata;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V1StatefulSetList v1StatefulSetList = (V1StatefulSetList)o;
        return Objects.equals(this.apiVersion, v1StatefulSetList.apiVersion) && Objects.equals(this.items, v1StatefulSetList.items) && Objects.equals(this.kind, v1StatefulSetList.kind) && Objects.equals(this.metadata, v1StatefulSetList.metadata);
    }

    public int hashCode() {
        return Objects.hash(this.apiVersion, this.items, this.kind, this.metadata);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class V1StatefulSetList {\n");
        sb.append("    apiVersion: ").append(this.toIndentedString(this.apiVersion)).append("\n");
        sb.append("    items: ").append(this.toIndentedString(this.items)).append("\n");
        sb.append("    kind: ").append(this.toIndentedString(this.kind)).append("\n");
        sb.append("    metadata: ").append(this.toIndentedString(this.metadata)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

