/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.models;

import com.google.gson.annotations.SerializedName;
import io.kubernetes.client.models.V1LabelSelector;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

@ApiModel(description="ExternalMetricStatus indicates the current value of a global metric not associated with any Kubernetes object.")
public class V2beta1ExternalMetricStatus {
    @SerializedName(value="currentAverageValue")
    private String currentAverageValue = null;
    @SerializedName(value="currentValue")
    private String currentValue = null;
    @SerializedName(value="metricName")
    private String metricName = null;
    @SerializedName(value="metricSelector")
    private V1LabelSelector metricSelector = null;

    public V2beta1ExternalMetricStatus currentAverageValue(String currentAverageValue) {
        this.currentAverageValue = currentAverageValue;
        return this;
    }

    @ApiModelProperty(value="currentAverageValue is the current value of metric averaged over autoscaled pods.")
    public String getCurrentAverageValue() {
        return this.currentAverageValue;
    }

    public void setCurrentAverageValue(String currentAverageValue) {
        this.currentAverageValue = currentAverageValue;
    }

    public V2beta1ExternalMetricStatus currentValue(String currentValue) {
        this.currentValue = currentValue;
        return this;
    }

    @ApiModelProperty(required=true, value="currentValue is the current value of the metric (as a quantity)")
    public String getCurrentValue() {
        return this.currentValue;
    }

    public void setCurrentValue(String currentValue) {
        this.currentValue = currentValue;
    }

    public V2beta1ExternalMetricStatus metricName(String metricName) {
        this.metricName = metricName;
        return this;
    }

    @ApiModelProperty(required=true, value="metricName is the name of a metric used for autoscaling in metric system.")
    public String getMetricName() {
        return this.metricName;
    }

    public void setMetricName(String metricName) {
        this.metricName = metricName;
    }

    public V2beta1ExternalMetricStatus metricSelector(V1LabelSelector metricSelector) {
        this.metricSelector = metricSelector;
        return this;
    }

    @ApiModelProperty(value="metricSelector is used to identify a specific time series within a given metric.")
    public V1LabelSelector getMetricSelector() {
        return this.metricSelector;
    }

    public void setMetricSelector(V1LabelSelector metricSelector) {
        this.metricSelector = metricSelector;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V2beta1ExternalMetricStatus v2beta1ExternalMetricStatus = (V2beta1ExternalMetricStatus)o;
        return Objects.equals(this.currentAverageValue, v2beta1ExternalMetricStatus.currentAverageValue) && Objects.equals(this.currentValue, v2beta1ExternalMetricStatus.currentValue) && Objects.equals(this.metricName, v2beta1ExternalMetricStatus.metricName) && Objects.equals(this.metricSelector, v2beta1ExternalMetricStatus.metricSelector);
    }

    public int hashCode() {
        return Objects.hash(this.currentAverageValue, this.currentValue, this.metricName, this.metricSelector);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class V2beta1ExternalMetricStatus {\n");
        sb.append("    currentAverageValue: ").append(this.toIndentedString(this.currentAverageValue)).append("\n");
        sb.append("    currentValue: ").append(this.toIndentedString(this.currentValue)).append("\n");
        sb.append("    metricName: ").append(this.toIndentedString(this.metricName)).append("\n");
        sb.append("    metricSelector: ").append(this.toIndentedString(this.metricSelector)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

