/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.models;

import com.google.gson.annotations.SerializedName;
import io.kubernetes.client.models.V1ObjectReference;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

@ApiModel(description="EndpointAddress is a tuple that describes single IP address.")
public class V1EndpointAddress {
    @SerializedName(value="hostname")
    private String hostname = null;
    @SerializedName(value="ip")
    private String ip = null;
    @SerializedName(value="nodeName")
    private String nodeName = null;
    @SerializedName(value="targetRef")
    private V1ObjectReference targetRef = null;

    public V1EndpointAddress hostname(String hostname) {
        this.hostname = hostname;
        return this;
    }

    @ApiModelProperty(value="The Hostname of this endpoint")
    public String getHostname() {
        return this.hostname;
    }

    public void setHostname(String hostname) {
        this.hostname = hostname;
    }

    public V1EndpointAddress ip(String ip) {
        this.ip = ip;
        return this;
    }

    @ApiModelProperty(required=true, value="The IP of this endpoint. May not be loopback (127.0.0.0/8), link-local (169.254.0.0/16), or link-local multicast ((224.0.0.0/24). IPv6 is also accepted but not fully supported on all platforms. Also, certain kubernetes components, like kube-proxy, are not IPv6 ready.")
    public String getIp() {
        return this.ip;
    }

    public void setIp(String ip) {
        this.ip = ip;
    }

    public V1EndpointAddress nodeName(String nodeName) {
        this.nodeName = nodeName;
        return this;
    }

    @ApiModelProperty(value="Optional: Node hosting this endpoint. This can be used to determine endpoints local to a node.")
    public String getNodeName() {
        return this.nodeName;
    }

    public void setNodeName(String nodeName) {
        this.nodeName = nodeName;
    }

    public V1EndpointAddress targetRef(V1ObjectReference targetRef) {
        this.targetRef = targetRef;
        return this;
    }

    @ApiModelProperty(value="Reference to object providing the endpoint.")
    public V1ObjectReference getTargetRef() {
        return this.targetRef;
    }

    public void setTargetRef(V1ObjectReference targetRef) {
        this.targetRef = targetRef;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V1EndpointAddress v1EndpointAddress = (V1EndpointAddress)o;
        return Objects.equals(this.hostname, v1EndpointAddress.hostname) && Objects.equals(this.ip, v1EndpointAddress.ip) && Objects.equals(this.nodeName, v1EndpointAddress.nodeName) && Objects.equals(this.targetRef, v1EndpointAddress.targetRef);
    }

    public int hashCode() {
        return Objects.hash(this.hostname, this.ip, this.nodeName, this.targetRef);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class V1EndpointAddress {\n");
        sb.append("    hostname: ").append(this.toIndentedString(this.hostname)).append("\n");
        sb.append("    ip: ").append(this.toIndentedString(this.ip)).append("\n");
        sb.append("    nodeName: ").append(this.toIndentedString(this.nodeName)).append("\n");
        sb.append("    targetRef: ").append(this.toIndentedString(this.targetRef)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

