/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.models;

import io.kubernetes.client.fluent.BaseFluent;
import io.kubernetes.client.fluent.Nested;
import io.kubernetes.client.fluent.Predicate;
import io.kubernetes.client.openapi.models.ApiextensionsV1WebhookClientConfig;
import io.kubernetes.client.openapi.models.ApiextensionsV1WebhookClientConfigBuilder;
import io.kubernetes.client.openapi.models.ApiextensionsV1WebhookClientConfigFluentImpl;
import io.kubernetes.client.openapi.models.V1WebhookConversion;
import io.kubernetes.client.openapi.models.V1WebhookConversionFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;

public class V1WebhookConversionFluentImpl<A extends V1WebhookConversionFluent<A>>
extends BaseFluent<A>
implements V1WebhookConversionFluent<A> {
    private ApiextensionsV1WebhookClientConfigBuilder clientConfig;
    private List<String> conversionReviewVersions;

    public V1WebhookConversionFluentImpl() {
    }

    public V1WebhookConversionFluentImpl(V1WebhookConversion instance) {
        this.withClientConfig(instance.getClientConfig());
        this.withConversionReviewVersions(instance.getConversionReviewVersions());
    }

    @Override
    @Deprecated
    public ApiextensionsV1WebhookClientConfig getClientConfig() {
        return this.clientConfig != null ? this.clientConfig.build() : null;
    }

    @Override
    public ApiextensionsV1WebhookClientConfig buildClientConfig() {
        return this.clientConfig != null ? this.clientConfig.build() : null;
    }

    @Override
    public A withClientConfig(ApiextensionsV1WebhookClientConfig clientConfig) {
        this._visitables.get("clientConfig").remove(this.clientConfig);
        if (clientConfig != null) {
            this.clientConfig = new ApiextensionsV1WebhookClientConfigBuilder(clientConfig);
            this._visitables.get("clientConfig").add(this.clientConfig);
        }
        return (A)this;
    }

    @Override
    public Boolean hasClientConfig() {
        return this.clientConfig != null;
    }

    @Override
    public V1WebhookConversionFluent.ClientConfigNested<A> withNewClientConfig() {
        return new ClientConfigNestedImpl();
    }

    @Override
    public V1WebhookConversionFluent.ClientConfigNested<A> withNewClientConfigLike(ApiextensionsV1WebhookClientConfig item) {
        return new ClientConfigNestedImpl(item);
    }

    @Override
    public V1WebhookConversionFluent.ClientConfigNested<A> editClientConfig() {
        return this.withNewClientConfigLike(this.getClientConfig());
    }

    @Override
    public V1WebhookConversionFluent.ClientConfigNested<A> editOrNewClientConfig() {
        return this.withNewClientConfigLike(this.getClientConfig() != null ? this.getClientConfig() : new ApiextensionsV1WebhookClientConfigBuilder().build());
    }

    @Override
    public V1WebhookConversionFluent.ClientConfigNested<A> editOrNewClientConfigLike(ApiextensionsV1WebhookClientConfig item) {
        return this.withNewClientConfigLike(this.getClientConfig() != null ? this.getClientConfig() : item);
    }

    @Override
    public A addToConversionReviewVersions(int index, String item) {
        if (this.conversionReviewVersions == null) {
            this.conversionReviewVersions = new ArrayList<String>();
        }
        this.conversionReviewVersions.add(index, item);
        return (A)this;
    }

    @Override
    public A setToConversionReviewVersions(int index, String item) {
        if (this.conversionReviewVersions == null) {
            this.conversionReviewVersions = new ArrayList<String>();
        }
        this.conversionReviewVersions.set(index, item);
        return (A)this;
    }

    @Override
    public A addToConversionReviewVersions(String ... items) {
        if (this.conversionReviewVersions == null) {
            this.conversionReviewVersions = new ArrayList<String>();
        }
        for (String item : items) {
            this.conversionReviewVersions.add(item);
        }
        return (A)this;
    }

    @Override
    public A addAllToConversionReviewVersions(Collection<String> items) {
        if (this.conversionReviewVersions == null) {
            this.conversionReviewVersions = new ArrayList<String>();
        }
        for (String item : items) {
            this.conversionReviewVersions.add(item);
        }
        return (A)this;
    }

    @Override
    public A removeFromConversionReviewVersions(String ... items) {
        for (String item : items) {
            if (this.conversionReviewVersions == null) continue;
            this.conversionReviewVersions.remove(item);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromConversionReviewVersions(Collection<String> items) {
        for (String item : items) {
            if (this.conversionReviewVersions == null) continue;
            this.conversionReviewVersions.remove(item);
        }
        return (A)this;
    }

    @Override
    public List<String> getConversionReviewVersions() {
        return this.conversionReviewVersions;
    }

    @Override
    public String getConversionReviewVersion(int index) {
        return this.conversionReviewVersions.get(index);
    }

    @Override
    public String getFirstConversionReviewVersion() {
        return this.conversionReviewVersions.get(0);
    }

    @Override
    public String getLastConversionReviewVersion() {
        return this.conversionReviewVersions.get(this.conversionReviewVersions.size() - 1);
    }

    @Override
    public String getMatchingConversionReviewVersion(Predicate<String> predicate) {
        for (String item : this.conversionReviewVersions) {
            if (!predicate.apply(item).booleanValue()) continue;
            return item;
        }
        return null;
    }

    @Override
    public Boolean hasMatchingConversionReviewVersion(Predicate<String> predicate) {
        for (String item : this.conversionReviewVersions) {
            if (!predicate.apply(item).booleanValue()) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withConversionReviewVersions(List<String> conversionReviewVersions) {
        if (this.conversionReviewVersions != null) {
            this._visitables.get("conversionReviewVersions").removeAll(this.conversionReviewVersions);
        }
        if (conversionReviewVersions != null) {
            this.conversionReviewVersions = new ArrayList<String>();
            for (String item : conversionReviewVersions) {
                this.addToConversionReviewVersions(item);
            }
        } else {
            this.conversionReviewVersions = null;
        }
        return (A)this;
    }

    @Override
    public A withConversionReviewVersions(String ... conversionReviewVersions) {
        if (this.conversionReviewVersions != null) {
            this.conversionReviewVersions.clear();
        }
        if (conversionReviewVersions != null) {
            for (String item : conversionReviewVersions) {
                this.addToConversionReviewVersions(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasConversionReviewVersions() {
        return this.conversionReviewVersions != null && !this.conversionReviewVersions.isEmpty();
    }

    @Override
    public A addNewConversionReviewVersion(String arg1) {
        return this.addToConversionReviewVersions(new String(arg1));
    }

    @Override
    public A addNewConversionReviewVersion(StringBuilder arg1) {
        return this.addToConversionReviewVersions(new String(arg1));
    }

    @Override
    public A addNewConversionReviewVersion(StringBuffer arg1) {
        return this.addToConversionReviewVersions(new String(arg1));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V1WebhookConversionFluentImpl that = (V1WebhookConversionFluentImpl)o;
        if (this.clientConfig != null ? !this.clientConfig.equals(that.clientConfig) : that.clientConfig != null) {
            return false;
        }
        return !(this.conversionReviewVersions != null ? !this.conversionReviewVersions.equals(that.conversionReviewVersions) : that.conversionReviewVersions != null);
    }

    public int hashCode() {
        return Objects.hash(this.clientConfig, this.conversionReviewVersions, super.hashCode());
    }

    public class ClientConfigNestedImpl<N>
    extends ApiextensionsV1WebhookClientConfigFluentImpl<V1WebhookConversionFluent.ClientConfigNested<N>>
    implements V1WebhookConversionFluent.ClientConfigNested<N>,
    Nested<N> {
        private final ApiextensionsV1WebhookClientConfigBuilder builder;

        ClientConfigNestedImpl(ApiextensionsV1WebhookClientConfig item) {
            this.builder = new ApiextensionsV1WebhookClientConfigBuilder(this, item);
        }

        ClientConfigNestedImpl() {
            this.builder = new ApiextensionsV1WebhookClientConfigBuilder(this);
        }

        @Override
        public N and() {
            return (N)V1WebhookConversionFluentImpl.this.withClientConfig(this.builder.build());
        }

        @Override
        public N endClientConfig() {
            return this.and();
        }
    }
}

