/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.models;

import io.kubernetes.client.fluent.BaseFluent;
import io.kubernetes.client.fluent.Nested;
import io.kubernetes.client.openapi.models.V1ObjectMeta;
import io.kubernetes.client.openapi.models.V1ObjectMetaBuilder;
import io.kubernetes.client.openapi.models.V1ObjectMetaFluentImpl;
import io.kubernetes.client.openapi.models.V1Overhead;
import io.kubernetes.client.openapi.models.V1OverheadBuilder;
import io.kubernetes.client.openapi.models.V1OverheadFluentImpl;
import io.kubernetes.client.openapi.models.V1RuntimeClass;
import io.kubernetes.client.openapi.models.V1RuntimeClassFluent;
import io.kubernetes.client.openapi.models.V1Scheduling;
import io.kubernetes.client.openapi.models.V1SchedulingBuilder;
import io.kubernetes.client.openapi.models.V1SchedulingFluentImpl;
import java.util.Objects;

public class V1RuntimeClassFluentImpl<A extends V1RuntimeClassFluent<A>>
extends BaseFluent<A>
implements V1RuntimeClassFluent<A> {
    private String apiVersion;
    private String handler;
    private String kind;
    private V1ObjectMetaBuilder metadata;
    private V1OverheadBuilder overhead;
    private V1SchedulingBuilder scheduling;

    public V1RuntimeClassFluentImpl() {
    }

    public V1RuntimeClassFluentImpl(V1RuntimeClass instance) {
        this.withApiVersion(instance.getApiVersion());
        this.withHandler(instance.getHandler());
        this.withKind(instance.getKind());
        this.withMetadata(instance.getMetadata());
        this.withOverhead(instance.getOverhead());
        this.withScheduling(instance.getScheduling());
    }

    @Override
    public String getApiVersion() {
        return this.apiVersion;
    }

    @Override
    public A withApiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
        return (A)this;
    }

    @Override
    public Boolean hasApiVersion() {
        return this.apiVersion != null;
    }

    @Override
    public A withNewApiVersion(String arg1) {
        return this.withApiVersion(new String(arg1));
    }

    @Override
    public A withNewApiVersion(StringBuilder arg1) {
        return this.withApiVersion(new String(arg1));
    }

    @Override
    public A withNewApiVersion(StringBuffer arg1) {
        return this.withApiVersion(new String(arg1));
    }

    @Override
    public String getHandler() {
        return this.handler;
    }

    @Override
    public A withHandler(String handler) {
        this.handler = handler;
        return (A)this;
    }

    @Override
    public Boolean hasHandler() {
        return this.handler != null;
    }

    @Override
    public A withNewHandler(String arg1) {
        return this.withHandler(new String(arg1));
    }

    @Override
    public A withNewHandler(StringBuilder arg1) {
        return this.withHandler(new String(arg1));
    }

    @Override
    public A withNewHandler(StringBuffer arg1) {
        return this.withHandler(new String(arg1));
    }

    @Override
    public String getKind() {
        return this.kind;
    }

    @Override
    public A withKind(String kind) {
        this.kind = kind;
        return (A)this;
    }

    @Override
    public Boolean hasKind() {
        return this.kind != null;
    }

    @Override
    public A withNewKind(String arg1) {
        return this.withKind(new String(arg1));
    }

    @Override
    public A withNewKind(StringBuilder arg1) {
        return this.withKind(new String(arg1));
    }

    @Override
    public A withNewKind(StringBuffer arg1) {
        return this.withKind(new String(arg1));
    }

    @Override
    @Deprecated
    public V1ObjectMeta getMetadata() {
        return this.metadata != null ? this.metadata.build() : null;
    }

    @Override
    public V1ObjectMeta buildMetadata() {
        return this.metadata != null ? this.metadata.build() : null;
    }

    @Override
    public A withMetadata(V1ObjectMeta metadata) {
        this._visitables.get("metadata").remove(this.metadata);
        if (metadata != null) {
            this.metadata = new V1ObjectMetaBuilder(metadata);
            this._visitables.get("metadata").add(this.metadata);
        }
        return (A)this;
    }

    @Override
    public Boolean hasMetadata() {
        return this.metadata != null;
    }

    @Override
    public V1RuntimeClassFluent.MetadataNested<A> withNewMetadata() {
        return new MetadataNestedImpl();
    }

    @Override
    public V1RuntimeClassFluent.MetadataNested<A> withNewMetadataLike(V1ObjectMeta item) {
        return new MetadataNestedImpl(item);
    }

    @Override
    public V1RuntimeClassFluent.MetadataNested<A> editMetadata() {
        return this.withNewMetadataLike(this.getMetadata());
    }

    @Override
    public V1RuntimeClassFluent.MetadataNested<A> editOrNewMetadata() {
        return this.withNewMetadataLike(this.getMetadata() != null ? this.getMetadata() : new V1ObjectMetaBuilder().build());
    }

    @Override
    public V1RuntimeClassFluent.MetadataNested<A> editOrNewMetadataLike(V1ObjectMeta item) {
        return this.withNewMetadataLike(this.getMetadata() != null ? this.getMetadata() : item);
    }

    @Override
    @Deprecated
    public V1Overhead getOverhead() {
        return this.overhead != null ? this.overhead.build() : null;
    }

    @Override
    public V1Overhead buildOverhead() {
        return this.overhead != null ? this.overhead.build() : null;
    }

    @Override
    public A withOverhead(V1Overhead overhead) {
        this._visitables.get("overhead").remove(this.overhead);
        if (overhead != null) {
            this.overhead = new V1OverheadBuilder(overhead);
            this._visitables.get("overhead").add(this.overhead);
        }
        return (A)this;
    }

    @Override
    public Boolean hasOverhead() {
        return this.overhead != null;
    }

    @Override
    public V1RuntimeClassFluent.OverheadNested<A> withNewOverhead() {
        return new OverheadNestedImpl();
    }

    @Override
    public V1RuntimeClassFluent.OverheadNested<A> withNewOverheadLike(V1Overhead item) {
        return new OverheadNestedImpl(item);
    }

    @Override
    public V1RuntimeClassFluent.OverheadNested<A> editOverhead() {
        return this.withNewOverheadLike(this.getOverhead());
    }

    @Override
    public V1RuntimeClassFluent.OverheadNested<A> editOrNewOverhead() {
        return this.withNewOverheadLike(this.getOverhead() != null ? this.getOverhead() : new V1OverheadBuilder().build());
    }

    @Override
    public V1RuntimeClassFluent.OverheadNested<A> editOrNewOverheadLike(V1Overhead item) {
        return this.withNewOverheadLike(this.getOverhead() != null ? this.getOverhead() : item);
    }

    @Override
    @Deprecated
    public V1Scheduling getScheduling() {
        return this.scheduling != null ? this.scheduling.build() : null;
    }

    @Override
    public V1Scheduling buildScheduling() {
        return this.scheduling != null ? this.scheduling.build() : null;
    }

    @Override
    public A withScheduling(V1Scheduling scheduling) {
        this._visitables.get("scheduling").remove(this.scheduling);
        if (scheduling != null) {
            this.scheduling = new V1SchedulingBuilder(scheduling);
            this._visitables.get("scheduling").add(this.scheduling);
        }
        return (A)this;
    }

    @Override
    public Boolean hasScheduling() {
        return this.scheduling != null;
    }

    @Override
    public V1RuntimeClassFluent.SchedulingNested<A> withNewScheduling() {
        return new SchedulingNestedImpl();
    }

    @Override
    public V1RuntimeClassFluent.SchedulingNested<A> withNewSchedulingLike(V1Scheduling item) {
        return new SchedulingNestedImpl(item);
    }

    @Override
    public V1RuntimeClassFluent.SchedulingNested<A> editScheduling() {
        return this.withNewSchedulingLike(this.getScheduling());
    }

    @Override
    public V1RuntimeClassFluent.SchedulingNested<A> editOrNewScheduling() {
        return this.withNewSchedulingLike(this.getScheduling() != null ? this.getScheduling() : new V1SchedulingBuilder().build());
    }

    @Override
    public V1RuntimeClassFluent.SchedulingNested<A> editOrNewSchedulingLike(V1Scheduling item) {
        return this.withNewSchedulingLike(this.getScheduling() != null ? this.getScheduling() : item);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V1RuntimeClassFluentImpl that = (V1RuntimeClassFluentImpl)o;
        if (this.apiVersion != null ? !this.apiVersion.equals(that.apiVersion) : that.apiVersion != null) {
            return false;
        }
        if (this.handler != null ? !this.handler.equals(that.handler) : that.handler != null) {
            return false;
        }
        if (this.kind != null ? !this.kind.equals(that.kind) : that.kind != null) {
            return false;
        }
        if (this.metadata != null ? !this.metadata.equals(that.metadata) : that.metadata != null) {
            return false;
        }
        if (this.overhead != null ? !this.overhead.equals(that.overhead) : that.overhead != null) {
            return false;
        }
        return !(this.scheduling != null ? !this.scheduling.equals(that.scheduling) : that.scheduling != null);
    }

    public int hashCode() {
        return Objects.hash(this.apiVersion, this.handler, this.kind, this.metadata, this.overhead, this.scheduling, super.hashCode());
    }

    public class SchedulingNestedImpl<N>
    extends V1SchedulingFluentImpl<V1RuntimeClassFluent.SchedulingNested<N>>
    implements V1RuntimeClassFluent.SchedulingNested<N>,
    Nested<N> {
        private final V1SchedulingBuilder builder;

        SchedulingNestedImpl(V1Scheduling item) {
            this.builder = new V1SchedulingBuilder(this, item);
        }

        SchedulingNestedImpl() {
            this.builder = new V1SchedulingBuilder(this);
        }

        @Override
        public N and() {
            return (N)V1RuntimeClassFluentImpl.this.withScheduling(this.builder.build());
        }

        @Override
        public N endScheduling() {
            return this.and();
        }
    }

    public class OverheadNestedImpl<N>
    extends V1OverheadFluentImpl<V1RuntimeClassFluent.OverheadNested<N>>
    implements V1RuntimeClassFluent.OverheadNested<N>,
    Nested<N> {
        private final V1OverheadBuilder builder;

        OverheadNestedImpl(V1Overhead item) {
            this.builder = new V1OverheadBuilder(this, item);
        }

        OverheadNestedImpl() {
            this.builder = new V1OverheadBuilder(this);
        }

        @Override
        public N and() {
            return (N)V1RuntimeClassFluentImpl.this.withOverhead(this.builder.build());
        }

        @Override
        public N endOverhead() {
            return this.and();
        }
    }

    public class MetadataNestedImpl<N>
    extends V1ObjectMetaFluentImpl<V1RuntimeClassFluent.MetadataNested<N>>
    implements V1RuntimeClassFluent.MetadataNested<N>,
    Nested<N> {
        private final V1ObjectMetaBuilder builder;

        MetadataNestedImpl(V1ObjectMeta item) {
            this.builder = new V1ObjectMetaBuilder(this, item);
        }

        MetadataNestedImpl() {
            this.builder = new V1ObjectMetaBuilder(this);
        }

        @Override
        public N and() {
            return (N)V1RuntimeClassFluentImpl.this.withMetadata(this.builder.build());
        }

        @Override
        public N endMetadata() {
            return this.and();
        }
    }
}

