/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.models;

import com.google.gson.annotations.SerializedName;
import io.kubernetes.client.openapi.models.V1LocalObjectReference;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="Represents a cinder volume resource in Openstack. A Cinder volume must exist before mounting to a container. The volume must also be in the same region as the kubelet. Cinder volumes support ownership management and SELinux relabeling.")
public class V1CinderVolumeSource {
    public static final String SERIALIZED_NAME_FS_TYPE = "fsType";
    @SerializedName(value="fsType")
    private String fsType;
    public static final String SERIALIZED_NAME_READ_ONLY = "readOnly";
    @SerializedName(value="readOnly")
    private Boolean readOnly;
    public static final String SERIALIZED_NAME_SECRET_REF = "secretRef";
    @SerializedName(value="secretRef")
    private V1LocalObjectReference secretRef;
    public static final String SERIALIZED_NAME_VOLUME_I_D = "volumeID";
    @SerializedName(value="volumeID")
    private String volumeID;

    public V1CinderVolumeSource fsType(String fsType) {
        this.fsType = fsType;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Filesystem type to mount. Must be a filesystem type supported by the host operating system. Examples: \"ext4\", \"xfs\", \"ntfs\". Implicitly inferred to be \"ext4\" if unspecified. More info: https://examples.k8s.io/mysql-cinder-pd/README.md")
    public String getFsType() {
        return this.fsType;
    }

    public void setFsType(String fsType) {
        this.fsType = fsType;
    }

    public V1CinderVolumeSource readOnly(Boolean readOnly) {
        this.readOnly = readOnly;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Optional: Defaults to false (read/write). ReadOnly here will force the ReadOnly setting in VolumeMounts. More info: https://examples.k8s.io/mysql-cinder-pd/README.md")
    public Boolean getReadOnly() {
        return this.readOnly;
    }

    public void setReadOnly(Boolean readOnly) {
        this.readOnly = readOnly;
    }

    public V1CinderVolumeSource secretRef(V1LocalObjectReference secretRef) {
        this.secretRef = secretRef;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public V1LocalObjectReference getSecretRef() {
        return this.secretRef;
    }

    public void setSecretRef(V1LocalObjectReference secretRef) {
        this.secretRef = secretRef;
    }

    public V1CinderVolumeSource volumeID(String volumeID) {
        this.volumeID = volumeID;
        return this;
    }

    @ApiModelProperty(required=true, value="volume id used to identify the volume in cinder. More info: https://examples.k8s.io/mysql-cinder-pd/README.md")
    public String getVolumeID() {
        return this.volumeID;
    }

    public void setVolumeID(String volumeID) {
        this.volumeID = volumeID;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V1CinderVolumeSource v1CinderVolumeSource = (V1CinderVolumeSource)o;
        return Objects.equals(this.fsType, v1CinderVolumeSource.fsType) && Objects.equals(this.readOnly, v1CinderVolumeSource.readOnly) && Objects.equals(this.secretRef, v1CinderVolumeSource.secretRef) && Objects.equals(this.volumeID, v1CinderVolumeSource.volumeID);
    }

    public int hashCode() {
        return Objects.hash(this.fsType, this.readOnly, this.secretRef, this.volumeID);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class V1CinderVolumeSource {\n");
        sb.append("    fsType: ").append(this.toIndentedString(this.fsType)).append("\n");
        sb.append("    readOnly: ").append(this.toIndentedString(this.readOnly)).append("\n");
        sb.append("    secretRef: ").append(this.toIndentedString(this.secretRef)).append("\n");
        sb.append("    volumeID: ").append(this.toIndentedString(this.volumeID)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

