package io.kubernetes.client.openapi.models;

import io.kubernetes.client.fluent.VisitableBuilder;
import com.google.gson.annotations.SerializedName;
import io.kubernetes.client.fluent.Nested;
import java.util.ArrayList;
import org.joda.time.DateTime;
import io.kubernetes.client.fluent.Predicate;
import java.lang.Deprecated;
import io.kubernetes.client.fluent.BaseFluent;
import java.util.Iterator;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;

public class V2alpha1CronJobStatusFluentImpl<A extends V2alpha1CronJobStatusFluent<A>> extends io.kubernetes.client.fluent.BaseFluent<A> implements V2alpha1CronJobStatusFluent<A> {

    private List<V1ObjectReferenceBuilder> active;
    private DateTime lastScheduleTime;

    public V2alpha1CronJobStatusFluentImpl() { 
    }


    public V2alpha1CronJobStatusFluentImpl(V2alpha1CronJobStatus instance) { 
        this.withActive(instance.getActive());

        this.withLastScheduleTime(instance.getLastScheduleTime());

    }


    public A addToActive(int index,V1ObjectReference item) {
        if (this.active == null) {this.active = new ArrayList<V1ObjectReferenceBuilder>();}
        V1ObjectReferenceBuilder builder = new V1ObjectReferenceBuilder(item);_visitables.get("active").add(index >= 0 ? index : _visitables.get("active").size(), builder);this.active.add(index >= 0 ? index : active.size(), builder); return (A)this;
    }

    public A setToActive(int index,V1ObjectReference item) {
        if (this.active == null) {this.active = new ArrayList<V1ObjectReferenceBuilder>();}
        V1ObjectReferenceBuilder builder = new V1ObjectReferenceBuilder(item);
        if (index < 0 || index >= _visitables.get("active").size()) { _visitables.get("active").add(builder); } else { _visitables.get("active").set(index, builder);}
        if (index < 0 || index >= active.size()) { active.add(builder); } else { active.set(index, builder);}
         return (A)this;
    }

    public A addToActive(V1ObjectReference... items) {
        if (this.active == null) {this.active = new ArrayList<V1ObjectReferenceBuilder>();}
        for (V1ObjectReference item : items) {V1ObjectReferenceBuilder builder = new V1ObjectReferenceBuilder(item);_visitables.get("active").add(builder);this.active.add(builder);} return (A)this;
    }

    public A addAllToActive(Collection<V1ObjectReference> items) {
        if (this.active == null) {this.active = new ArrayList<V1ObjectReferenceBuilder>();}
        for (V1ObjectReference item : items) {V1ObjectReferenceBuilder builder = new V1ObjectReferenceBuilder(item);_visitables.get("active").add(builder);this.active.add(builder);} return (A)this;
    }

    public A removeFromActive(V1ObjectReference... items) {
        for (V1ObjectReference item : items) {V1ObjectReferenceBuilder builder = new V1ObjectReferenceBuilder(item);_visitables.get("active").remove(builder);if (this.active != null) {this.active.remove(builder);}} return (A)this;
    }

    public A removeAllFromActive(Collection<V1ObjectReference> items) {
        for (V1ObjectReference item : items) {V1ObjectReferenceBuilder builder = new V1ObjectReferenceBuilder(item);_visitables.get("active").remove(builder);if (this.active != null) {this.active.remove(builder);}} return (A)this;
    }

    public A removeMatchingFromActive(io.kubernetes.client.fluent.Predicate<V1ObjectReferenceBuilder> predicate) {
        if (active == null) return (A) this;
        final Iterator<V1ObjectReferenceBuilder> each = active.iterator();
        final List visitables = _visitables.get("active");
        while (each.hasNext()) {
          V1ObjectReferenceBuilder builder = each.next();
          if (predicate.apply(builder)) {
            visitables.remove(builder);
            each.remove();
          }
        }
        return (A)this;
    }

    
/**
 * This method has been deprecated, please use method buildActive instead.
 * @return The buildable object.
 */
@Deprecated public List<V1ObjectReference> getActive() {
        return build(active);
    }

    public List<V1ObjectReference> buildActive() {
        return build(active);
    }

    public V1ObjectReference buildActive(int index) {
        return this.active.get(index).build();
    }

    public V1ObjectReference buildFirstActive() {
        return this.active.get(0).build();
    }

    public V1ObjectReference buildLastActive() {
        return this.active.get(active.size() - 1).build();
    }

    public V1ObjectReference buildMatchingActive(io.kubernetes.client.fluent.Predicate<V1ObjectReferenceBuilder> predicate) {
        for (V1ObjectReferenceBuilder item: active) { if(predicate.apply(item)){ return item.build();} } return null;
    }

    public Boolean hasMatchingActive(io.kubernetes.client.fluent.Predicate<V1ObjectReferenceBuilder> predicate) {
        for (V1ObjectReferenceBuilder item: active) { if(predicate.apply(item)){ return true;} } return false;
    }

    public A withActive(List<V1ObjectReference> active) {
        if (this.active != null) { _visitables.get("active").removeAll(this.active);}
        if (active != null) {this.active = new ArrayList<V1ObjectReferenceBuilder>(); for (V1ObjectReference item : active){this.addToActive(item);}} else { this.active = null;} return (A) this;
    }

    public A withActive(V1ObjectReference... active) {
        if (this.active != null) {this.active.clear();}
        if (active != null) {for (V1ObjectReference item :active){ this.addToActive(item);}} return (A) this;
    }

    public Boolean hasActive() {
        return active != null && !active.isEmpty();
    }

    public V2alpha1CronJobStatusFluent.ActiveNested<A> addNewActive() {
        return new ActiveNestedImpl();
    }

    public V2alpha1CronJobStatusFluent.ActiveNested<A> addNewActiveLike(V1ObjectReference item) {
        return new ActiveNestedImpl(-1, item);
    }

    public V2alpha1CronJobStatusFluent.ActiveNested<A> setNewActiveLike(int index,V1ObjectReference item) {
        return new ActiveNestedImpl(index, item);
    }

    public V2alpha1CronJobStatusFluent.ActiveNested<A> editActive(int index) {
        if (active.size() <= index) throw new RuntimeException("Can't edit active. Index exceeds size.");
        return setNewActiveLike(index, buildActive(index));
    }

    public V2alpha1CronJobStatusFluent.ActiveNested<A> editFirstActive() {
        if (active.size() == 0) throw new RuntimeException("Can't edit first active. The list is empty.");
        return setNewActiveLike(0, buildActive(0));
    }

    public V2alpha1CronJobStatusFluent.ActiveNested<A> editLastActive() {
        int index = active.size() - 1;
        if (index < 0) throw new RuntimeException("Can't edit last active. The list is empty.");
        return setNewActiveLike(index, buildActive(index));
    }

    public V2alpha1CronJobStatusFluent.ActiveNested<A> editMatchingActive(io.kubernetes.client.fluent.Predicate<V1ObjectReferenceBuilder> predicate) {
        int index = -1;
        for (int i=0;i<active.size();i++) { 
        if (predicate.apply(active.get(i))) {index = i; break;}
        } 
        if (index < 0) throw new RuntimeException("Can't edit matching active. No match found.");
        return setNewActiveLike(index, buildActive(index));
    }

    public DateTime getLastScheduleTime() {
        return this.lastScheduleTime;
    }

    public A withLastScheduleTime(DateTime lastScheduleTime) {
        this.lastScheduleTime=lastScheduleTime; return (A) this;
    }

    public Boolean hasLastScheduleTime() {
        return this.lastScheduleTime != null;
    }

    public A withNewLastScheduleTime(int arg0,int arg1,int arg2,int arg3,int arg4) {
        return (A)withLastScheduleTime(new DateTime(arg0, arg1, arg2, arg3, arg4));
    }

    public A withNewLastScheduleTime(Object arg0) {
        return (A)withLastScheduleTime(new DateTime(arg0));
    }

    public A withNewLastScheduleTime(long arg0) {
        return (A)withLastScheduleTime(new DateTime(arg0));
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        V2alpha1CronJobStatusFluentImpl that = (V2alpha1CronJobStatusFluentImpl) o;
        if (active != null ? !active.equals(that.active) :that.active != null) return false;
        if (lastScheduleTime != null ? !lastScheduleTime.equals(that.lastScheduleTime) :that.lastScheduleTime != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(active,  lastScheduleTime,  super.hashCode());
    }

    public class ActiveNestedImpl<N> extends V1ObjectReferenceFluentImpl<V2alpha1CronJobStatusFluent.ActiveNested<N>> implements V2alpha1CronJobStatusFluent.ActiveNested<N>,io.kubernetes.client.fluent.Nested<N> {
        private final V1ObjectReferenceBuilder builder;
        private final int index;

        ActiveNestedImpl(int index,V1ObjectReference item) {
            this.index = index;
            this.builder = new V1ObjectReferenceBuilder(this, item);
        }

        ActiveNestedImpl() {
            this.index = -1;
            this.builder = new V1ObjectReferenceBuilder(this);
        }

        public N and() {
             return (N) V2alpha1CronJobStatusFluentImpl.this.setToActive(index,builder.build());
        }

        public N endActive() {
             return and();
        }
    }


}
