package io.kubernetes.client.openapi.models;

import io.kubernetes.client.fluent.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class V1beta1PodDisruptionBudgetBuilder extends V1beta1PodDisruptionBudgetFluentImpl<V1beta1PodDisruptionBudgetBuilder> implements VisitableBuilder<V1beta1PodDisruptionBudget,V1beta1PodDisruptionBudgetBuilder> {

    V1beta1PodDisruptionBudgetFluent<?> fluent;
    Boolean validationEnabled;

    public V1beta1PodDisruptionBudgetBuilder() { 
        this(true);
    }


    public V1beta1PodDisruptionBudgetBuilder(Boolean validationEnabled) { 
        this(new V1beta1PodDisruptionBudget(), validationEnabled);
    }


    public V1beta1PodDisruptionBudgetBuilder(V1beta1PodDisruptionBudgetFluent<?> fluent) { 
        this(fluent, true);
    }


    public V1beta1PodDisruptionBudgetBuilder(V1beta1PodDisruptionBudgetFluent<?> fluent,Boolean validationEnabled) { 
        this(fluent, new V1beta1PodDisruptionBudget(), validationEnabled);
    }


    public V1beta1PodDisruptionBudgetBuilder(V1beta1PodDisruptionBudgetFluent<?> fluent,V1beta1PodDisruptionBudget instance) { 
        this(fluent, instance, true);
    }


    public V1beta1PodDisruptionBudgetBuilder(V1beta1PodDisruptionBudgetFluent<?> fluent,V1beta1PodDisruptionBudget instance,Boolean validationEnabled) { 
        this.fluent = fluent; 
        fluent.withApiVersion(instance.getApiVersion());

        fluent.withKind(instance.getKind());

        fluent.withMetadata(instance.getMetadata());

        fluent.withSpec(instance.getSpec());

        fluent.withStatus(instance.getStatus());

        this.validationEnabled = validationEnabled; 
    }


    public V1beta1PodDisruptionBudgetBuilder(V1beta1PodDisruptionBudget instance) { 
        this(instance,true);
    }


    public V1beta1PodDisruptionBudgetBuilder(V1beta1PodDisruptionBudget instance,Boolean validationEnabled) { 
        this.fluent = this; 
        this.withApiVersion(instance.getApiVersion());

        this.withKind(instance.getKind());

        this.withMetadata(instance.getMetadata());

        this.withSpec(instance.getSpec());

        this.withStatus(instance.getStatus());

        this.validationEnabled = validationEnabled; 
    }


    public V1beta1PodDisruptionBudget build() {
        V1beta1PodDisruptionBudget buildable = new V1beta1PodDisruptionBudget();
        buildable.setApiVersion(fluent.getApiVersion());
        buildable.setKind(fluent.getKind());
        buildable.setMetadata(fluent.getMetadata());
        buildable.setSpec(fluent.getSpec());
        buildable.setStatus(fluent.getStatus());
        return buildable;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        V1beta1PodDisruptionBudgetBuilder that = (V1beta1PodDisruptionBudgetBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
