package io.kubernetes.client.openapi.models;

import java.lang.StringBuilder;
import com.google.gson.annotations.SerializedName;
import io.kubernetes.client.fluent.Nested;
import java.lang.String;
import java.lang.StringBuffer;
import java.lang.Deprecated;
import io.kubernetes.client.fluent.BaseFluent;
import java.lang.Object;
import java.lang.Boolean;

public class V1alpha1RuntimeClassSpecFluentImpl<A extends V1alpha1RuntimeClassSpecFluent<A>> extends io.kubernetes.client.fluent.BaseFluent<A> implements V1alpha1RuntimeClassSpecFluent<A> {

    private V1alpha1OverheadBuilder overhead;
    private String runtimeHandler;
    private V1alpha1SchedulingBuilder scheduling;

    public V1alpha1RuntimeClassSpecFluentImpl() { 
    }


    public V1alpha1RuntimeClassSpecFluentImpl(V1alpha1RuntimeClassSpec instance) { 
        this.withOverhead(instance.getOverhead());

        this.withRuntimeHandler(instance.getRuntimeHandler());

        this.withScheduling(instance.getScheduling());

    }


    
/**
 * This method has been deprecated, please use method buildOverhead instead.
 * @return The buildable object.
 */
@Deprecated public V1alpha1Overhead getOverhead() {
        return this.overhead!=null?this.overhead.build():null;
    }

    public V1alpha1Overhead buildOverhead() {
        return this.overhead!=null?this.overhead.build():null;
    }

    public A withOverhead(V1alpha1Overhead overhead) {
        _visitables.get("overhead").remove(this.overhead);
        if (overhead!=null){ this.overhead= new V1alpha1OverheadBuilder(overhead); _visitables.get("overhead").add(this.overhead);} return (A) this;
    }

    public Boolean hasOverhead() {
        return this.overhead != null;
    }

    public V1alpha1RuntimeClassSpecFluent.OverheadNested<A> withNewOverhead() {
        return new OverheadNestedImpl();
    }

    public V1alpha1RuntimeClassSpecFluent.OverheadNested<A> withNewOverheadLike(V1alpha1Overhead item) {
        return new OverheadNestedImpl(item);
    }

    public V1alpha1RuntimeClassSpecFluent.OverheadNested<A> editOverhead() {
        return withNewOverheadLike(getOverhead());
    }

    public V1alpha1RuntimeClassSpecFluent.OverheadNested<A> editOrNewOverhead() {
        return withNewOverheadLike(getOverhead() != null ? getOverhead(): new V1alpha1OverheadBuilder().build());
    }

    public V1alpha1RuntimeClassSpecFluent.OverheadNested<A> editOrNewOverheadLike(V1alpha1Overhead item) {
        return withNewOverheadLike(getOverhead() != null ? getOverhead(): item);
    }

    public String getRuntimeHandler() {
        return this.runtimeHandler;
    }

    public A withRuntimeHandler(String runtimeHandler) {
        this.runtimeHandler=runtimeHandler; return (A) this;
    }

    public Boolean hasRuntimeHandler() {
        return this.runtimeHandler != null;
    }

    public A withNewRuntimeHandler(String arg1) {
        return (A)withRuntimeHandler(new String(arg1));
    }

    public A withNewRuntimeHandler(StringBuilder arg1) {
        return (A)withRuntimeHandler(new String(arg1));
    }

    public A withNewRuntimeHandler(StringBuffer arg1) {
        return (A)withRuntimeHandler(new String(arg1));
    }

    
/**
 * This method has been deprecated, please use method buildScheduling instead.
 * @return The buildable object.
 */
@Deprecated public V1alpha1Scheduling getScheduling() {
        return this.scheduling!=null?this.scheduling.build():null;
    }

    public V1alpha1Scheduling buildScheduling() {
        return this.scheduling!=null?this.scheduling.build():null;
    }

    public A withScheduling(V1alpha1Scheduling scheduling) {
        _visitables.get("scheduling").remove(this.scheduling);
        if (scheduling!=null){ this.scheduling= new V1alpha1SchedulingBuilder(scheduling); _visitables.get("scheduling").add(this.scheduling);} return (A) this;
    }

    public Boolean hasScheduling() {
        return this.scheduling != null;
    }

    public V1alpha1RuntimeClassSpecFluent.SchedulingNested<A> withNewScheduling() {
        return new SchedulingNestedImpl();
    }

    public V1alpha1RuntimeClassSpecFluent.SchedulingNested<A> withNewSchedulingLike(V1alpha1Scheduling item) {
        return new SchedulingNestedImpl(item);
    }

    public V1alpha1RuntimeClassSpecFluent.SchedulingNested<A> editScheduling() {
        return withNewSchedulingLike(getScheduling());
    }

    public V1alpha1RuntimeClassSpecFluent.SchedulingNested<A> editOrNewScheduling() {
        return withNewSchedulingLike(getScheduling() != null ? getScheduling(): new V1alpha1SchedulingBuilder().build());
    }

    public V1alpha1RuntimeClassSpecFluent.SchedulingNested<A> editOrNewSchedulingLike(V1alpha1Scheduling item) {
        return withNewSchedulingLike(getScheduling() != null ? getScheduling(): item);
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        V1alpha1RuntimeClassSpecFluentImpl that = (V1alpha1RuntimeClassSpecFluentImpl) o;
        if (overhead != null ? !overhead.equals(that.overhead) :that.overhead != null) return false;
        if (runtimeHandler != null ? !runtimeHandler.equals(that.runtimeHandler) :that.runtimeHandler != null) return false;
        if (scheduling != null ? !scheduling.equals(that.scheduling) :that.scheduling != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(overhead,  runtimeHandler,  scheduling,  super.hashCode());
    }

    public class OverheadNestedImpl<N> extends V1alpha1OverheadFluentImpl<V1alpha1RuntimeClassSpecFluent.OverheadNested<N>> implements V1alpha1RuntimeClassSpecFluent.OverheadNested<N>,io.kubernetes.client.fluent.Nested<N> {
        private final V1alpha1OverheadBuilder builder;

        OverheadNestedImpl(V1alpha1Overhead item) {
            this.builder = new V1alpha1OverheadBuilder(this, item);
        }

        OverheadNestedImpl() {
            this.builder = new V1alpha1OverheadBuilder(this);
        }

        public N and() {
             return (N) V1alpha1RuntimeClassSpecFluentImpl.this.withOverhead(builder.build());
        }

        public N endOverhead() {
             return and();
        }
    }


    public class SchedulingNestedImpl<N> extends V1alpha1SchedulingFluentImpl<V1alpha1RuntimeClassSpecFluent.SchedulingNested<N>> implements V1alpha1RuntimeClassSpecFluent.SchedulingNested<N>,io.kubernetes.client.fluent.Nested<N> {
        private final V1alpha1SchedulingBuilder builder;

        SchedulingNestedImpl(V1alpha1Scheduling item) {
            this.builder = new V1alpha1SchedulingBuilder(this, item);
        }

        SchedulingNestedImpl() {
            this.builder = new V1alpha1SchedulingBuilder(this);
        }

        public N and() {
             return (N) V1alpha1RuntimeClassSpecFluentImpl.this.withScheduling(builder.build());
        }

        public N endScheduling() {
             return and();
        }
    }


}
