package io.kubernetes.client.openapi.models;

import com.google.gson.annotations.SerializedName;
import io.kubernetes.client.fluent.Nested;
import java.lang.Integer;
import java.lang.Deprecated;
import io.kubernetes.client.fluent.BaseFluent;
import java.lang.Object;
import java.lang.Boolean;

public class V1alpha1LimitedPriorityLevelConfigurationFluentImpl<A extends V1alpha1LimitedPriorityLevelConfigurationFluent<A>> extends io.kubernetes.client.fluent.BaseFluent<A> implements V1alpha1LimitedPriorityLevelConfigurationFluent<A> {

    private Integer assuredConcurrencyShares;
    private V1alpha1LimitResponseBuilder limitResponse;

    public V1alpha1LimitedPriorityLevelConfigurationFluentImpl() { 
    }


    public V1alpha1LimitedPriorityLevelConfigurationFluentImpl(V1alpha1LimitedPriorityLevelConfiguration instance) { 
        this.withAssuredConcurrencyShares(instance.getAssuredConcurrencyShares());

        this.withLimitResponse(instance.getLimitResponse());

    }


    public Integer getAssuredConcurrencyShares() {
        return this.assuredConcurrencyShares;
    }

    public A withAssuredConcurrencyShares(Integer assuredConcurrencyShares) {
        this.assuredConcurrencyShares=assuredConcurrencyShares; return (A) this;
    }

    public Boolean hasAssuredConcurrencyShares() {
        return this.assuredConcurrencyShares != null;
    }

    
/**
 * This method has been deprecated, please use method buildLimitResponse instead.
 * @return The buildable object.
 */
@Deprecated public V1alpha1LimitResponse getLimitResponse() {
        return this.limitResponse!=null?this.limitResponse.build():null;
    }

    public V1alpha1LimitResponse buildLimitResponse() {
        return this.limitResponse!=null?this.limitResponse.build():null;
    }

    public A withLimitResponse(V1alpha1LimitResponse limitResponse) {
        _visitables.get("limitResponse").remove(this.limitResponse);
        if (limitResponse!=null){ this.limitResponse= new V1alpha1LimitResponseBuilder(limitResponse); _visitables.get("limitResponse").add(this.limitResponse);} return (A) this;
    }

    public Boolean hasLimitResponse() {
        return this.limitResponse != null;
    }

    public V1alpha1LimitedPriorityLevelConfigurationFluent.LimitResponseNested<A> withNewLimitResponse() {
        return new LimitResponseNestedImpl();
    }

    public V1alpha1LimitedPriorityLevelConfigurationFluent.LimitResponseNested<A> withNewLimitResponseLike(V1alpha1LimitResponse item) {
        return new LimitResponseNestedImpl(item);
    }

    public V1alpha1LimitedPriorityLevelConfigurationFluent.LimitResponseNested<A> editLimitResponse() {
        return withNewLimitResponseLike(getLimitResponse());
    }

    public V1alpha1LimitedPriorityLevelConfigurationFluent.LimitResponseNested<A> editOrNewLimitResponse() {
        return withNewLimitResponseLike(getLimitResponse() != null ? getLimitResponse(): new V1alpha1LimitResponseBuilder().build());
    }

    public V1alpha1LimitedPriorityLevelConfigurationFluent.LimitResponseNested<A> editOrNewLimitResponseLike(V1alpha1LimitResponse item) {
        return withNewLimitResponseLike(getLimitResponse() != null ? getLimitResponse(): item);
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        V1alpha1LimitedPriorityLevelConfigurationFluentImpl that = (V1alpha1LimitedPriorityLevelConfigurationFluentImpl) o;
        if (assuredConcurrencyShares != null ? !assuredConcurrencyShares.equals(that.assuredConcurrencyShares) :that.assuredConcurrencyShares != null) return false;
        if (limitResponse != null ? !limitResponse.equals(that.limitResponse) :that.limitResponse != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(assuredConcurrencyShares,  limitResponse,  super.hashCode());
    }

    public class LimitResponseNestedImpl<N> extends V1alpha1LimitResponseFluentImpl<V1alpha1LimitedPriorityLevelConfigurationFluent.LimitResponseNested<N>> implements V1alpha1LimitedPriorityLevelConfigurationFluent.LimitResponseNested<N>,io.kubernetes.client.fluent.Nested<N> {
        private final V1alpha1LimitResponseBuilder builder;

        LimitResponseNestedImpl(V1alpha1LimitResponse item) {
            this.builder = new V1alpha1LimitResponseBuilder(this, item);
        }

        LimitResponseNestedImpl() {
            this.builder = new V1alpha1LimitResponseBuilder(this);
        }

        public N and() {
             return (N) V1alpha1LimitedPriorityLevelConfigurationFluentImpl.this.withLimitResponse(builder.build());
        }

        public N endLimitResponse() {
             return and();
        }
    }


}
