package io.kubernetes.client.openapi.models;

import io.kubernetes.client.fluent.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class V1alpha1FlowSchemaStatusBuilder extends V1alpha1FlowSchemaStatusFluentImpl<V1alpha1FlowSchemaStatusBuilder> implements VisitableBuilder<V1alpha1FlowSchemaStatus,V1alpha1FlowSchemaStatusBuilder> {

    V1alpha1FlowSchemaStatusFluent<?> fluent;
    Boolean validationEnabled;

    public V1alpha1FlowSchemaStatusBuilder() { 
        this(true);
    }


    public V1alpha1FlowSchemaStatusBuilder(Boolean validationEnabled) { 
        this(new V1alpha1FlowSchemaStatus(), validationEnabled);
    }


    public V1alpha1FlowSchemaStatusBuilder(V1alpha1FlowSchemaStatusFluent<?> fluent) { 
        this(fluent, true);
    }


    public V1alpha1FlowSchemaStatusBuilder(V1alpha1FlowSchemaStatusFluent<?> fluent,Boolean validationEnabled) { 
        this(fluent, new V1alpha1FlowSchemaStatus(), validationEnabled);
    }


    public V1alpha1FlowSchemaStatusBuilder(V1alpha1FlowSchemaStatusFluent<?> fluent,V1alpha1FlowSchemaStatus instance) { 
        this(fluent, instance, true);
    }


    public V1alpha1FlowSchemaStatusBuilder(V1alpha1FlowSchemaStatusFluent<?> fluent,V1alpha1FlowSchemaStatus instance,Boolean validationEnabled) { 
        this.fluent = fluent; 
        fluent.withConditions(instance.getConditions());

        this.validationEnabled = validationEnabled; 
    }


    public V1alpha1FlowSchemaStatusBuilder(V1alpha1FlowSchemaStatus instance) { 
        this(instance,true);
    }


    public V1alpha1FlowSchemaStatusBuilder(V1alpha1FlowSchemaStatus instance,Boolean validationEnabled) { 
        this.fluent = this; 
        this.withConditions(instance.getConditions());

        this.validationEnabled = validationEnabled; 
    }


    public V1alpha1FlowSchemaStatus build() {
        V1alpha1FlowSchemaStatus buildable = new V1alpha1FlowSchemaStatus();
        buildable.setConditions(fluent.getConditions());
        return buildable;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        V1alpha1FlowSchemaStatusBuilder that = (V1alpha1FlowSchemaStatusBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
