package io.kubernetes.client.openapi.models;

import io.kubernetes.client.fluent.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class V1TypedLocalObjectReferenceBuilder extends V1TypedLocalObjectReferenceFluentImpl<V1TypedLocalObjectReferenceBuilder> implements VisitableBuilder<V1TypedLocalObjectReference,V1TypedLocalObjectReferenceBuilder> {

    V1TypedLocalObjectReferenceFluent<?> fluent;
    Boolean validationEnabled;

    public V1TypedLocalObjectReferenceBuilder() { 
        this(true);
    }


    public V1TypedLocalObjectReferenceBuilder(Boolean validationEnabled) { 
        this(new V1TypedLocalObjectReference(), validationEnabled);
    }


    public V1TypedLocalObjectReferenceBuilder(V1TypedLocalObjectReferenceFluent<?> fluent) { 
        this(fluent, true);
    }


    public V1TypedLocalObjectReferenceBuilder(V1TypedLocalObjectReferenceFluent<?> fluent,Boolean validationEnabled) { 
        this(fluent, new V1TypedLocalObjectReference(), validationEnabled);
    }


    public V1TypedLocalObjectReferenceBuilder(V1TypedLocalObjectReferenceFluent<?> fluent,V1TypedLocalObjectReference instance) { 
        this(fluent, instance, true);
    }


    public V1TypedLocalObjectReferenceBuilder(V1TypedLocalObjectReferenceFluent<?> fluent,V1TypedLocalObjectReference instance,Boolean validationEnabled) { 
        this.fluent = fluent; 
        fluent.withApiGroup(instance.getApiGroup());

        fluent.withKind(instance.getKind());

        fluent.withName(instance.getName());

        this.validationEnabled = validationEnabled; 
    }


    public V1TypedLocalObjectReferenceBuilder(V1TypedLocalObjectReference instance) { 
        this(instance,true);
    }


    public V1TypedLocalObjectReferenceBuilder(V1TypedLocalObjectReference instance,Boolean validationEnabled) { 
        this.fluent = this; 
        this.withApiGroup(instance.getApiGroup());

        this.withKind(instance.getKind());

        this.withName(instance.getName());

        this.validationEnabled = validationEnabled; 
    }


    public V1TypedLocalObjectReference build() {
        V1TypedLocalObjectReference buildable = new V1TypedLocalObjectReference();
        buildable.setApiGroup(fluent.getApiGroup());
        buildable.setKind(fluent.getKind());
        buildable.setName(fluent.getName());
        return buildable;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        V1TypedLocalObjectReferenceBuilder that = (V1TypedLocalObjectReferenceBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
