package io.kubernetes.client.openapi.models;

import io.kubernetes.client.fluent.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class V1IngressStatusBuilder extends V1IngressStatusFluentImpl<V1IngressStatusBuilder> implements VisitableBuilder<V1IngressStatus,V1IngressStatusBuilder> {

    V1IngressStatusFluent<?> fluent;
    Boolean validationEnabled;

    public V1IngressStatusBuilder() { 
        this(true);
    }


    public V1IngressStatusBuilder(Boolean validationEnabled) { 
        this(new V1IngressStatus(), validationEnabled);
    }


    public V1IngressStatusBuilder(V1IngressStatusFluent<?> fluent) { 
        this(fluent, true);
    }


    public V1IngressStatusBuilder(V1IngressStatusFluent<?> fluent,Boolean validationEnabled) { 
        this(fluent, new V1IngressStatus(), validationEnabled);
    }


    public V1IngressStatusBuilder(V1IngressStatusFluent<?> fluent,V1IngressStatus instance) { 
        this(fluent, instance, true);
    }


    public V1IngressStatusBuilder(V1IngressStatusFluent<?> fluent,V1IngressStatus instance,Boolean validationEnabled) { 
        this.fluent = fluent; 
        fluent.withLoadBalancer(instance.getLoadBalancer());

        this.validationEnabled = validationEnabled; 
    }


    public V1IngressStatusBuilder(V1IngressStatus instance) { 
        this(instance,true);
    }


    public V1IngressStatusBuilder(V1IngressStatus instance,Boolean validationEnabled) { 
        this.fluent = this; 
        this.withLoadBalancer(instance.getLoadBalancer());

        this.validationEnabled = validationEnabled; 
    }


    public V1IngressStatus build() {
        V1IngressStatus buildable = new V1IngressStatus();
        buildable.setLoadBalancer(fluent.getLoadBalancer());
        return buildable;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        V1IngressStatusBuilder that = (V1IngressStatusBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
