package io.kubernetes.client.openapi.models;

import io.kubernetes.client.fluent.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class NetworkingV1beta1IngressListBuilder extends NetworkingV1beta1IngressListFluentImpl<NetworkingV1beta1IngressListBuilder> implements VisitableBuilder<NetworkingV1beta1IngressList,NetworkingV1beta1IngressListBuilder> {

    NetworkingV1beta1IngressListFluent<?> fluent;
    Boolean validationEnabled;

    public NetworkingV1beta1IngressListBuilder() { 
        this(true);
    }


    public NetworkingV1beta1IngressListBuilder(Boolean validationEnabled) { 
        this(new NetworkingV1beta1IngressList(), validationEnabled);
    }


    public NetworkingV1beta1IngressListBuilder(NetworkingV1beta1IngressListFluent<?> fluent) { 
        this(fluent, true);
    }


    public NetworkingV1beta1IngressListBuilder(NetworkingV1beta1IngressListFluent<?> fluent,Boolean validationEnabled) { 
        this(fluent, new NetworkingV1beta1IngressList(), validationEnabled);
    }


    public NetworkingV1beta1IngressListBuilder(NetworkingV1beta1IngressListFluent<?> fluent,NetworkingV1beta1IngressList instance) { 
        this(fluent, instance, true);
    }


    public NetworkingV1beta1IngressListBuilder(NetworkingV1beta1IngressListFluent<?> fluent,NetworkingV1beta1IngressList instance,Boolean validationEnabled) { 
        this.fluent = fluent; 
        fluent.withApiVersion(instance.getApiVersion());

        fluent.withItems(instance.getItems());

        fluent.withKind(instance.getKind());

        fluent.withMetadata(instance.getMetadata());

        this.validationEnabled = validationEnabled; 
    }


    public NetworkingV1beta1IngressListBuilder(NetworkingV1beta1IngressList instance) { 
        this(instance,true);
    }


    public NetworkingV1beta1IngressListBuilder(NetworkingV1beta1IngressList instance,Boolean validationEnabled) { 
        this.fluent = this; 
        this.withApiVersion(instance.getApiVersion());

        this.withItems(instance.getItems());

        this.withKind(instance.getKind());

        this.withMetadata(instance.getMetadata());

        this.validationEnabled = validationEnabled; 
    }


    public NetworkingV1beta1IngressList build() {
        NetworkingV1beta1IngressList buildable = new NetworkingV1beta1IngressList();
        buildable.setApiVersion(fluent.getApiVersion());
        buildable.setItems(fluent.getItems());
        buildable.setKind(fluent.getKind());
        buildable.setMetadata(fluent.getMetadata());
        return buildable;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        NetworkingV1beta1IngressListBuilder that = (NetworkingV1beta1IngressListBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
