package io.kubernetes.client.openapi.models;

import java.lang.StringBuilder;
import io.kubernetes.client.custom.IntOrString;
import com.google.gson.annotations.SerializedName;
import io.kubernetes.client.fluent.Nested;
import java.lang.String;
import java.lang.StringBuffer;
import java.lang.Deprecated;
import io.kubernetes.client.fluent.BaseFluent;
import java.lang.Object;
import java.lang.Boolean;

public class NetworkingV1beta1IngressBackendFluentImpl<A extends NetworkingV1beta1IngressBackendFluent<A>> extends io.kubernetes.client.fluent.BaseFluent<A> implements NetworkingV1beta1IngressBackendFluent<A> {

    private V1TypedLocalObjectReferenceBuilder resource;
    private String serviceName;
    private IntOrString servicePort;

    public NetworkingV1beta1IngressBackendFluentImpl() { 
    }


    public NetworkingV1beta1IngressBackendFluentImpl(NetworkingV1beta1IngressBackend instance) { 
        this.withResource(instance.getResource());

        this.withServiceName(instance.getServiceName());

        this.withServicePort(instance.getServicePort());

    }


    
/**
 * This method has been deprecated, please use method buildResource instead.
 * @return The buildable object.
 */
@Deprecated public V1TypedLocalObjectReference getResource() {
        return this.resource!=null?this.resource.build():null;
    }

    public V1TypedLocalObjectReference buildResource() {
        return this.resource!=null?this.resource.build():null;
    }

    public A withResource(V1TypedLocalObjectReference resource) {
        _visitables.get("resource").remove(this.resource);
        if (resource!=null){ this.resource= new V1TypedLocalObjectReferenceBuilder(resource); _visitables.get("resource").add(this.resource);} return (A) this;
    }

    public Boolean hasResource() {
        return this.resource != null;
    }

    public NetworkingV1beta1IngressBackendFluent.ResourceNested<A> withNewResource() {
        return new ResourceNestedImpl();
    }

    public NetworkingV1beta1IngressBackendFluent.ResourceNested<A> withNewResourceLike(V1TypedLocalObjectReference item) {
        return new ResourceNestedImpl(item);
    }

    public NetworkingV1beta1IngressBackendFluent.ResourceNested<A> editResource() {
        return withNewResourceLike(getResource());
    }

    public NetworkingV1beta1IngressBackendFluent.ResourceNested<A> editOrNewResource() {
        return withNewResourceLike(getResource() != null ? getResource(): new V1TypedLocalObjectReferenceBuilder().build());
    }

    public NetworkingV1beta1IngressBackendFluent.ResourceNested<A> editOrNewResourceLike(V1TypedLocalObjectReference item) {
        return withNewResourceLike(getResource() != null ? getResource(): item);
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public A withServiceName(String serviceName) {
        this.serviceName=serviceName; return (A) this;
    }

    public Boolean hasServiceName() {
        return this.serviceName != null;
    }

    public A withNewServiceName(String arg1) {
        return (A)withServiceName(new String(arg1));
    }

    public A withNewServiceName(StringBuilder arg1) {
        return (A)withServiceName(new String(arg1));
    }

    public A withNewServiceName(StringBuffer arg1) {
        return (A)withServiceName(new String(arg1));
    }

    public IntOrString getServicePort() {
        return this.servicePort;
    }

    public A withServicePort(IntOrString servicePort) {
        this.servicePort=servicePort; return (A) this;
    }

    public Boolean hasServicePort() {
        return this.servicePort != null;
    }

    public A withNewServicePort(final int value) {
        return (A)withServicePort(new IntOrString(value));
    }

    public A withNewServicePort(final String value) {
        return (A)withServicePort(new IntOrString(value));
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        NetworkingV1beta1IngressBackendFluentImpl that = (NetworkingV1beta1IngressBackendFluentImpl) o;
        if (resource != null ? !resource.equals(that.resource) :that.resource != null) return false;
        if (serviceName != null ? !serviceName.equals(that.serviceName) :that.serviceName != null) return false;
        if (servicePort != null ? !servicePort.equals(that.servicePort) :that.servicePort != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(resource,  serviceName,  servicePort,  super.hashCode());
    }

    public class ResourceNestedImpl<N> extends V1TypedLocalObjectReferenceFluentImpl<NetworkingV1beta1IngressBackendFluent.ResourceNested<N>> implements NetworkingV1beta1IngressBackendFluent.ResourceNested<N>,io.kubernetes.client.fluent.Nested<N> {
        private final V1TypedLocalObjectReferenceBuilder builder;

        ResourceNestedImpl(V1TypedLocalObjectReference item) {
            this.builder = new V1TypedLocalObjectReferenceBuilder(this, item);
        }

        ResourceNestedImpl() {
            this.builder = new V1TypedLocalObjectReferenceBuilder(this);
        }

        public N and() {
             return (N) NetworkingV1beta1IngressBackendFluentImpl.this.withResource(builder.build());
        }

        public N endResource() {
             return and();
        }
    }


}
