package io.kubernetes.client.openapi.models;

import io.kubernetes.client.fluent.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class CoreV1EventSeriesBuilder extends CoreV1EventSeriesFluentImpl<CoreV1EventSeriesBuilder> implements VisitableBuilder<CoreV1EventSeries,CoreV1EventSeriesBuilder> {

    CoreV1EventSeriesFluent<?> fluent;
    Boolean validationEnabled;

    public CoreV1EventSeriesBuilder() { 
        this(true);
    }


    public CoreV1EventSeriesBuilder(Boolean validationEnabled) { 
        this(new CoreV1EventSeries(), validationEnabled);
    }


    public CoreV1EventSeriesBuilder(CoreV1EventSeriesFluent<?> fluent) { 
        this(fluent, true);
    }


    public CoreV1EventSeriesBuilder(CoreV1EventSeriesFluent<?> fluent,Boolean validationEnabled) { 
        this(fluent, new CoreV1EventSeries(), validationEnabled);
    }


    public CoreV1EventSeriesBuilder(CoreV1EventSeriesFluent<?> fluent,CoreV1EventSeries instance) { 
        this(fluent, instance, true);
    }


    public CoreV1EventSeriesBuilder(CoreV1EventSeriesFluent<?> fluent,CoreV1EventSeries instance,Boolean validationEnabled) { 
        this.fluent = fluent; 
        fluent.withCount(instance.getCount());

        fluent.withLastObservedTime(instance.getLastObservedTime());

        this.validationEnabled = validationEnabled; 
    }


    public CoreV1EventSeriesBuilder(CoreV1EventSeries instance) { 
        this(instance,true);
    }


    public CoreV1EventSeriesBuilder(CoreV1EventSeries instance,Boolean validationEnabled) { 
        this.fluent = this; 
        this.withCount(instance.getCount());

        this.withLastObservedTime(instance.getLastObservedTime());

        this.validationEnabled = validationEnabled; 
    }


    public CoreV1EventSeries build() {
        CoreV1EventSeries buildable = new CoreV1EventSeries();
        buildable.setCount(fluent.getCount());
        buildable.setLastObservedTime(fluent.getLastObservedTime());
        return buildable;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        CoreV1EventSeriesBuilder that = (CoreV1EventSeriesBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
