/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.models;

import com.google.gson.annotations.SerializedName;
import io.kubernetes.client.openapi.models.V1beta1CustomResourceColumnDefinition;
import io.kubernetes.client.openapi.models.V1beta1CustomResourceSubresources;
import io.kubernetes.client.openapi.models.V1beta1CustomResourceValidation;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="CustomResourceDefinitionVersion describes a version for CRD.")
public class V1beta1CustomResourceDefinitionVersion {
    public static final String SERIALIZED_NAME_ADDITIONAL_PRINTER_COLUMNS = "additionalPrinterColumns";
    @SerializedName(value="additionalPrinterColumns")
    private List<V1beta1CustomResourceColumnDefinition> additionalPrinterColumns = null;
    public static final String SERIALIZED_NAME_NAME = "name";
    @SerializedName(value="name")
    private String name;
    public static final String SERIALIZED_NAME_SCHEMA = "schema";
    @SerializedName(value="schema")
    private V1beta1CustomResourceValidation schema;
    public static final String SERIALIZED_NAME_SERVED = "served";
    @SerializedName(value="served")
    private Boolean served;
    public static final String SERIALIZED_NAME_STORAGE = "storage";
    @SerializedName(value="storage")
    private Boolean storage;
    public static final String SERIALIZED_NAME_SUBRESOURCES = "subresources";
    @SerializedName(value="subresources")
    private V1beta1CustomResourceSubresources subresources;

    public V1beta1CustomResourceDefinitionVersion additionalPrinterColumns(List<V1beta1CustomResourceColumnDefinition> additionalPrinterColumns) {
        this.additionalPrinterColumns = additionalPrinterColumns;
        return this;
    }

    public V1beta1CustomResourceDefinitionVersion addAdditionalPrinterColumnsItem(V1beta1CustomResourceColumnDefinition additionalPrinterColumnsItem) {
        if (this.additionalPrinterColumns == null) {
            this.additionalPrinterColumns = new ArrayList<V1beta1CustomResourceColumnDefinition>();
        }
        this.additionalPrinterColumns.add(additionalPrinterColumnsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="additionalPrinterColumns specifies additional columns returned in Table output. See https://kubernetes.io/docs/reference/using-api/api-concepts/#receiving-resources-as-tables for details. Top-level and per-version columns are mutually exclusive. Per-version columns must not all be set to identical values (top-level columns should be used instead). If no top-level or per-version columns are specified, a single column displaying the age of the custom resource is used.")
    public List<V1beta1CustomResourceColumnDefinition> getAdditionalPrinterColumns() {
        return this.additionalPrinterColumns;
    }

    public void setAdditionalPrinterColumns(List<V1beta1CustomResourceColumnDefinition> additionalPrinterColumns) {
        this.additionalPrinterColumns = additionalPrinterColumns;
    }

    public V1beta1CustomResourceDefinitionVersion name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(required=true, value="name is the version name, e.g. \u201cv1\u201d, \u201cv2beta1\u201d, etc. The custom resources are served under this version at `/apis/<group>/<version>/...` if `served` is true.")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public V1beta1CustomResourceDefinitionVersion schema(V1beta1CustomResourceValidation schema) {
        this.schema = schema;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public V1beta1CustomResourceValidation getSchema() {
        return this.schema;
    }

    public void setSchema(V1beta1CustomResourceValidation schema) {
        this.schema = schema;
    }

    public V1beta1CustomResourceDefinitionVersion served(Boolean served) {
        this.served = served;
        return this;
    }

    @ApiModelProperty(required=true, value="served is a flag enabling/disabling this version from being served via REST APIs")
    public Boolean getServed() {
        return this.served;
    }

    public void setServed(Boolean served) {
        this.served = served;
    }

    public V1beta1CustomResourceDefinitionVersion storage(Boolean storage) {
        this.storage = storage;
        return this;
    }

    @ApiModelProperty(required=true, value="storage indicates this version should be used when persisting custom resources to storage. There must be exactly one version with storage=true.")
    public Boolean getStorage() {
        return this.storage;
    }

    public void setStorage(Boolean storage) {
        this.storage = storage;
    }

    public V1beta1CustomResourceDefinitionVersion subresources(V1beta1CustomResourceSubresources subresources) {
        this.subresources = subresources;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public V1beta1CustomResourceSubresources getSubresources() {
        return this.subresources;
    }

    public void setSubresources(V1beta1CustomResourceSubresources subresources) {
        this.subresources = subresources;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V1beta1CustomResourceDefinitionVersion v1beta1CustomResourceDefinitionVersion = (V1beta1CustomResourceDefinitionVersion)o;
        return Objects.equals(this.additionalPrinterColumns, v1beta1CustomResourceDefinitionVersion.additionalPrinterColumns) && Objects.equals(this.name, v1beta1CustomResourceDefinitionVersion.name) && Objects.equals(this.schema, v1beta1CustomResourceDefinitionVersion.schema) && Objects.equals(this.served, v1beta1CustomResourceDefinitionVersion.served) && Objects.equals(this.storage, v1beta1CustomResourceDefinitionVersion.storage) && Objects.equals(this.subresources, v1beta1CustomResourceDefinitionVersion.subresources);
    }

    public int hashCode() {
        return Objects.hash(this.additionalPrinterColumns, this.name, this.schema, this.served, this.storage, this.subresources);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class V1beta1CustomResourceDefinitionVersion {\n");
        sb.append("    additionalPrinterColumns: ").append(this.toIndentedString(this.additionalPrinterColumns)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    schema: ").append(this.toIndentedString(this.schema)).append("\n");
        sb.append("    served: ").append(this.toIndentedString(this.served)).append("\n");
        sb.append("    storage: ").append(this.toIndentedString(this.storage)).append("\n");
        sb.append("    subresources: ").append(this.toIndentedString(this.subresources)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

