/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.models;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="Policy defines the configuration of how audit events are logged")
public class V1alpha1Policy {
    public static final String SERIALIZED_NAME_LEVEL = "level";
    @SerializedName(value="level")
    private String level;
    public static final String SERIALIZED_NAME_STAGES = "stages";
    @SerializedName(value="stages")
    private List<String> stages = null;

    public V1alpha1Policy level(String level) {
        this.level = level;
        return this;
    }

    @ApiModelProperty(required=true, value="The Level that all requests are recorded at. available options: None, Metadata, Request, RequestResponse required")
    public String getLevel() {
        return this.level;
    }

    public void setLevel(String level) {
        this.level = level;
    }

    public V1alpha1Policy stages(List<String> stages) {
        this.stages = stages;
        return this;
    }

    public V1alpha1Policy addStagesItem(String stagesItem) {
        if (this.stages == null) {
            this.stages = new ArrayList<String>();
        }
        this.stages.add(stagesItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Stages is a list of stages for which events are created.")
    public List<String> getStages() {
        return this.stages;
    }

    public void setStages(List<String> stages) {
        this.stages = stages;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V1alpha1Policy v1alpha1Policy = (V1alpha1Policy)o;
        return Objects.equals(this.level, v1alpha1Policy.level) && Objects.equals(this.stages, v1alpha1Policy.stages);
    }

    public int hashCode() {
        return Objects.hash(this.level, this.stages);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class V1alpha1Policy {\n");
        sb.append("    level: ").append(this.toIndentedString(this.level)).append("\n");
        sb.append("    stages: ").append(this.toIndentedString(this.stages)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

