/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.models;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

@ApiModel(description="VolumeMount describes a mounting of a Volume within a container.")
public class V1VolumeMount {
    @SerializedName(value="mountPath")
    private String mountPath = null;
    @SerializedName(value="mountPropagation")
    private String mountPropagation = null;
    @SerializedName(value="name")
    private String name = null;
    @SerializedName(value="readOnly")
    private Boolean readOnly = null;
    @SerializedName(value="subPath")
    private String subPath = null;

    public V1VolumeMount mountPath(String mountPath) {
        this.mountPath = mountPath;
        return this;
    }

    @ApiModelProperty(required=true, value="Path within the container at which the volume should be mounted.  Must not contain ':'.")
    public String getMountPath() {
        return this.mountPath;
    }

    public void setMountPath(String mountPath) {
        this.mountPath = mountPath;
    }

    public V1VolumeMount mountPropagation(String mountPropagation) {
        this.mountPropagation = mountPropagation;
        return this;
    }

    @ApiModelProperty(value="mountPropagation determines how mounts are propagated from the host to container and the other way around. When not set, MountPropagationHostToContainer is used. This field is alpha in 1.8 and can be reworked or removed in a future release.")
    public String getMountPropagation() {
        return this.mountPropagation;
    }

    public void setMountPropagation(String mountPropagation) {
        this.mountPropagation = mountPropagation;
    }

    public V1VolumeMount name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(required=true, value="This must match the Name of a Volume.")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public V1VolumeMount readOnly(Boolean readOnly) {
        this.readOnly = readOnly;
        return this;
    }

    @ApiModelProperty(value="Mounted read-only if true, read-write otherwise (false or unspecified). Defaults to false.")
    public Boolean isReadOnly() {
        return this.readOnly;
    }

    public void setReadOnly(Boolean readOnly) {
        this.readOnly = readOnly;
    }

    public V1VolumeMount subPath(String subPath) {
        this.subPath = subPath;
        return this;
    }

    @ApiModelProperty(value="Path within the volume from which the container's volume should be mounted. Defaults to \"\" (volume's root).")
    public String getSubPath() {
        return this.subPath;
    }

    public void setSubPath(String subPath) {
        this.subPath = subPath;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V1VolumeMount v1VolumeMount = (V1VolumeMount)o;
        return Objects.equals(this.mountPath, v1VolumeMount.mountPath) && Objects.equals(this.mountPropagation, v1VolumeMount.mountPropagation) && Objects.equals(this.name, v1VolumeMount.name) && Objects.equals(this.readOnly, v1VolumeMount.readOnly) && Objects.equals(this.subPath, v1VolumeMount.subPath);
    }

    public int hashCode() {
        return Objects.hash(this.mountPath, this.mountPropagation, this.name, this.readOnly, this.subPath);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class V1VolumeMount {\n");
        sb.append("    mountPath: ").append(this.toIndentedString(this.mountPath)).append("\n");
        sb.append("    mountPropagation: ").append(this.toIndentedString(this.mountPropagation)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    readOnly: ").append(this.toIndentedString(this.readOnly)).append("\n");
        sb.append("    subPath: ").append(this.toIndentedString(this.subPath)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

