/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.models;

import com.google.gson.annotations.SerializedName;
import io.kubernetes.client.models.V1ObjectReference;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

@ApiModel(description="NodeConfigSource specifies a source of node configuration. Exactly one subfield (excluding metadata) must be non-nil.")
public class V1NodeConfigSource {
    @SerializedName(value="apiVersion")
    private String apiVersion = null;
    @SerializedName(value="configMapRef")
    private V1ObjectReference configMapRef = null;
    @SerializedName(value="kind")
    private String kind = null;

    public V1NodeConfigSource apiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
        return this;
    }

    @ApiModelProperty(value="APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#resources")
    public String getApiVersion() {
        return this.apiVersion;
    }

    public void setApiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
    }

    public V1NodeConfigSource configMapRef(V1ObjectReference configMapRef) {
        this.configMapRef = configMapRef;
        return this;
    }

    @ApiModelProperty(value="")
    public V1ObjectReference getConfigMapRef() {
        return this.configMapRef;
    }

    public void setConfigMapRef(V1ObjectReference configMapRef) {
        this.configMapRef = configMapRef;
    }

    public V1NodeConfigSource kind(String kind) {
        this.kind = kind;
        return this;
    }

    @ApiModelProperty(value="Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#types-kinds")
    public String getKind() {
        return this.kind;
    }

    public void setKind(String kind) {
        this.kind = kind;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V1NodeConfigSource v1NodeConfigSource = (V1NodeConfigSource)o;
        return Objects.equals(this.apiVersion, v1NodeConfigSource.apiVersion) && Objects.equals(this.configMapRef, v1NodeConfigSource.configMapRef) && Objects.equals(this.kind, v1NodeConfigSource.kind);
    }

    public int hashCode() {
        return Objects.hash(this.apiVersion, this.configMapRef, this.kind);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class V1NodeConfigSource {\n");
        sb.append("    apiVersion: ").append(this.toIndentedString(this.apiVersion)).append("\n");
        sb.append("    configMapRef: ").append(this.toIndentedString(this.configMapRef)).append("\n");
        sb.append("    kind: ").append(this.toIndentedString(this.kind)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

