/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.models;

import com.google.gson.annotations.SerializedName;
import io.kubernetes.client.models.V2beta1CrossVersionObjectReference;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

@ApiModel(description="ObjectMetricSource indicates how to scale on a metric describing a kubernetes object (for example, hits-per-second on an Ingress object).")
public class V2beta1ObjectMetricSource {
    @SerializedName(value="metricName")
    private String metricName = null;
    @SerializedName(value="target")
    private V2beta1CrossVersionObjectReference target = null;
    @SerializedName(value="targetValue")
    private String targetValue = null;

    public V2beta1ObjectMetricSource metricName(String metricName) {
        this.metricName = metricName;
        return this;
    }

    @ApiModelProperty(required=true, value="metricName is the name of the metric in question.")
    public String getMetricName() {
        return this.metricName;
    }

    public void setMetricName(String metricName) {
        this.metricName = metricName;
    }

    public V2beta1ObjectMetricSource target(V2beta1CrossVersionObjectReference target) {
        this.target = target;
        return this;
    }

    @ApiModelProperty(required=true, value="target is the described Kubernetes object.")
    public V2beta1CrossVersionObjectReference getTarget() {
        return this.target;
    }

    public void setTarget(V2beta1CrossVersionObjectReference target) {
        this.target = target;
    }

    public V2beta1ObjectMetricSource targetValue(String targetValue) {
        this.targetValue = targetValue;
        return this;
    }

    @ApiModelProperty(required=true, value="targetValue is the target value of the metric (as a quantity).")
    public String getTargetValue() {
        return this.targetValue;
    }

    public void setTargetValue(String targetValue) {
        this.targetValue = targetValue;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V2beta1ObjectMetricSource v2beta1ObjectMetricSource = (V2beta1ObjectMetricSource)o;
        return Objects.equals(this.metricName, v2beta1ObjectMetricSource.metricName) && Objects.equals(this.target, v2beta1ObjectMetricSource.target) && Objects.equals(this.targetValue, v2beta1ObjectMetricSource.targetValue);
    }

    public int hashCode() {
        return Objects.hash(this.metricName, this.target, this.targetValue);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class V2beta1ObjectMetricSource {\n");
        sb.append("    metricName: ").append(this.toIndentedString(this.metricName)).append("\n");
        sb.append("    target: ").append(this.toIndentedString(this.target)).append("\n");
        sb.append("    targetValue: ").append(this.toIndentedString(this.targetValue)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

