/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.models;

import com.google.gson.annotations.SerializedName;
import io.kubernetes.client.models.V2beta1ObjectMetricStatus;
import io.kubernetes.client.models.V2beta1PodsMetricStatus;
import io.kubernetes.client.models.V2beta1ResourceMetricStatus;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

@ApiModel(description="MetricStatus describes the last-read state of a single metric.")
public class V2beta1MetricStatus {
    @SerializedName(value="object")
    private V2beta1ObjectMetricStatus object = null;
    @SerializedName(value="pods")
    private V2beta1PodsMetricStatus pods = null;
    @SerializedName(value="resource")
    private V2beta1ResourceMetricStatus resource = null;
    @SerializedName(value="type")
    private String type = null;

    public V2beta1MetricStatus object(V2beta1ObjectMetricStatus object) {
        this.object = object;
        return this;
    }

    @ApiModelProperty(value="object refers to a metric describing a single kubernetes object (for example, hits-per-second on an Ingress object).")
    public V2beta1ObjectMetricStatus getObject() {
        return this.object;
    }

    public void setObject(V2beta1ObjectMetricStatus object) {
        this.object = object;
    }

    public V2beta1MetricStatus pods(V2beta1PodsMetricStatus pods) {
        this.pods = pods;
        return this;
    }

    @ApiModelProperty(value="pods refers to a metric describing each pod in the current scale target (for example, transactions-processed-per-second).  The values will be averaged together before being compared to the target value.")
    public V2beta1PodsMetricStatus getPods() {
        return this.pods;
    }

    public void setPods(V2beta1PodsMetricStatus pods) {
        this.pods = pods;
    }

    public V2beta1MetricStatus resource(V2beta1ResourceMetricStatus resource) {
        this.resource = resource;
        return this;
    }

    @ApiModelProperty(value="resource refers to a resource metric (such as those specified in requests and limits) known to Kubernetes describing each pod in the current scale target (e.g. CPU or memory). Such metrics are built in to Kubernetes, and have special scaling options on top of those available to normal per-pod metrics using the \"pods\" source.")
    public V2beta1ResourceMetricStatus getResource() {
        return this.resource;
    }

    public void setResource(V2beta1ResourceMetricStatus resource) {
        this.resource = resource;
    }

    public V2beta1MetricStatus type(String type) {
        this.type = type;
        return this;
    }

    @ApiModelProperty(required=true, value="type is the type of metric source.  It will match one of the fields below.")
    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V2beta1MetricStatus v2beta1MetricStatus = (V2beta1MetricStatus)o;
        return Objects.equals(this.object, v2beta1MetricStatus.object) && Objects.equals(this.pods, v2beta1MetricStatus.pods) && Objects.equals(this.resource, v2beta1MetricStatus.resource) && Objects.equals(this.type, v2beta1MetricStatus.type);
    }

    public int hashCode() {
        return Objects.hash(this.object, this.pods, this.resource, this.type);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class V2beta1MetricStatus {\n");
        sb.append("    object: ").append(this.toIndentedString(this.object)).append("\n");
        sb.append("    pods: ").append(this.toIndentedString(this.pods)).append("\n");
        sb.append("    resource: ").append(this.toIndentedString(this.resource)).append("\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

