/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.models;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

@ApiModel(description="Represents a Quobyte mount that lasts the lifetime of a pod. Quobyte volumes do not support ownership management or SELinux relabeling.")
public class V1QuobyteVolumeSource {
    @SerializedName(value="group")
    private String group = null;
    @SerializedName(value="readOnly")
    private Boolean readOnly = null;
    @SerializedName(value="registry")
    private String registry = null;
    @SerializedName(value="user")
    private String user = null;
    @SerializedName(value="volume")
    private String volume = null;

    public V1QuobyteVolumeSource group(String group) {
        this.group = group;
        return this;
    }

    @ApiModelProperty(value="Group to map volume access to Default is no group")
    public String getGroup() {
        return this.group;
    }

    public void setGroup(String group) {
        this.group = group;
    }

    public V1QuobyteVolumeSource readOnly(Boolean readOnly) {
        this.readOnly = readOnly;
        return this;
    }

    @ApiModelProperty(value="ReadOnly here will force the Quobyte volume to be mounted with read-only permissions. Defaults to false.")
    public Boolean isReadOnly() {
        return this.readOnly;
    }

    public void setReadOnly(Boolean readOnly) {
        this.readOnly = readOnly;
    }

    public V1QuobyteVolumeSource registry(String registry) {
        this.registry = registry;
        return this;
    }

    @ApiModelProperty(required=true, value="Registry represents a single or multiple Quobyte Registry services specified as a string as host:port pair (multiple entries are separated with commas) which acts as the central registry for volumes")
    public String getRegistry() {
        return this.registry;
    }

    public void setRegistry(String registry) {
        this.registry = registry;
    }

    public V1QuobyteVolumeSource user(String user) {
        this.user = user;
        return this;
    }

    @ApiModelProperty(value="User to map volume access to Defaults to serivceaccount user")
    public String getUser() {
        return this.user;
    }

    public void setUser(String user) {
        this.user = user;
    }

    public V1QuobyteVolumeSource volume(String volume) {
        this.volume = volume;
        return this;
    }

    @ApiModelProperty(required=true, value="Volume is a string that references an already created Quobyte volume by name.")
    public String getVolume() {
        return this.volume;
    }

    public void setVolume(String volume) {
        this.volume = volume;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V1QuobyteVolumeSource v1QuobyteVolumeSource = (V1QuobyteVolumeSource)o;
        return Objects.equals(this.group, v1QuobyteVolumeSource.group) && Objects.equals(this.readOnly, v1QuobyteVolumeSource.readOnly) && Objects.equals(this.registry, v1QuobyteVolumeSource.registry) && Objects.equals(this.user, v1QuobyteVolumeSource.user) && Objects.equals(this.volume, v1QuobyteVolumeSource.volume);
    }

    public int hashCode() {
        return Objects.hash(this.group, this.readOnly, this.registry, this.user, this.volume);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class V1QuobyteVolumeSource {\n");
        sb.append("    group: ").append(this.toIndentedString(this.group)).append("\n");
        sb.append("    readOnly: ").append(this.toIndentedString(this.readOnly)).append("\n");
        sb.append("    registry: ").append(this.toIndentedString(this.registry)).append("\n");
        sb.append("    user: ").append(this.toIndentedString(this.user)).append("\n");
        sb.append("    volume: ").append(this.toIndentedString(this.volume)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

