/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.models;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

@ApiModel(description="ObjectReference contains enough information to let you inspect or modify the referred object.")
public class V1ObjectReference {
    @SerializedName(value="apiVersion")
    private String apiVersion = null;
    @SerializedName(value="fieldPath")
    private String fieldPath = null;
    @SerializedName(value="kind")
    private String kind = null;
    @SerializedName(value="name")
    private String name = null;
    @SerializedName(value="namespace")
    private String namespace = null;
    @SerializedName(value="resourceVersion")
    private String resourceVersion = null;
    @SerializedName(value="uid")
    private String uid = null;

    public V1ObjectReference apiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
        return this;
    }

    @ApiModelProperty(value="API version of the referent.")
    public String getApiVersion() {
        return this.apiVersion;
    }

    public void setApiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
    }

    public V1ObjectReference fieldPath(String fieldPath) {
        this.fieldPath = fieldPath;
        return this;
    }

    @ApiModelProperty(value="If referring to a piece of an object instead of an entire object, this string should contain a valid JSON/Go field access statement, such as desiredState.manifest.containers[2]. For example, if the object reference is to a container within a pod, this would take on a value like: \"spec.containers{name}\" (where \"name\" refers to the name of the container that triggered the event) or if no container name is specified \"spec.containers[2]\" (container with index 2 in this pod). This syntax is chosen only to have some well-defined way of referencing a part of an object.")
    public String getFieldPath() {
        return this.fieldPath;
    }

    public void setFieldPath(String fieldPath) {
        this.fieldPath = fieldPath;
    }

    public V1ObjectReference kind(String kind) {
        this.kind = kind;
        return this;
    }

    @ApiModelProperty(value="Kind of the referent. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#types-kinds")
    public String getKind() {
        return this.kind;
    }

    public void setKind(String kind) {
        this.kind = kind;
    }

    public V1ObjectReference name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(value="Name of the referent. More info: https://kubernetes.io/docs/concepts/overview/working-with-objects/names/#names")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public V1ObjectReference namespace(String namespace) {
        this.namespace = namespace;
        return this;
    }

    @ApiModelProperty(value="Namespace of the referent. More info: https://kubernetes.io/docs/concepts/overview/working-with-objects/namespaces/")
    public String getNamespace() {
        return this.namespace;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    public V1ObjectReference resourceVersion(String resourceVersion) {
        this.resourceVersion = resourceVersion;
        return this;
    }

    @ApiModelProperty(value="Specific resourceVersion to which this reference is made, if any. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#concurrency-control-and-consistency")
    public String getResourceVersion() {
        return this.resourceVersion;
    }

    public void setResourceVersion(String resourceVersion) {
        this.resourceVersion = resourceVersion;
    }

    public V1ObjectReference uid(String uid) {
        this.uid = uid;
        return this;
    }

    @ApiModelProperty(value="UID of the referent. More info: https://kubernetes.io/docs/concepts/overview/working-with-objects/names/#uids")
    public String getUid() {
        return this.uid;
    }

    public void setUid(String uid) {
        this.uid = uid;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V1ObjectReference v1ObjectReference = (V1ObjectReference)o;
        return Objects.equals(this.apiVersion, v1ObjectReference.apiVersion) && Objects.equals(this.fieldPath, v1ObjectReference.fieldPath) && Objects.equals(this.kind, v1ObjectReference.kind) && Objects.equals(this.name, v1ObjectReference.name) && Objects.equals(this.namespace, v1ObjectReference.namespace) && Objects.equals(this.resourceVersion, v1ObjectReference.resourceVersion) && Objects.equals(this.uid, v1ObjectReference.uid);
    }

    public int hashCode() {
        return Objects.hash(this.apiVersion, this.fieldPath, this.kind, this.name, this.namespace, this.resourceVersion, this.uid);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class V1ObjectReference {\n");
        sb.append("    apiVersion: ").append(this.toIndentedString(this.apiVersion)).append("\n");
        sb.append("    fieldPath: ").append(this.toIndentedString(this.fieldPath)).append("\n");
        sb.append("    kind: ").append(this.toIndentedString(this.kind)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    namespace: ").append(this.toIndentedString(this.namespace)).append("\n");
        sb.append("    resourceVersion: ").append(this.toIndentedString(this.resourceVersion)).append("\n");
        sb.append("    uid: ").append(this.toIndentedString(this.uid)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

