/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.models;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

@ApiModel(description="ResourceQuotaSpec defines the desired hard limits to enforce for Quota.")
public class V1ResourceQuotaSpec {
    @SerializedName(value="hard")
    private Map<String, String> hard = null;
    @SerializedName(value="scopes")
    private List<String> scopes = null;

    public V1ResourceQuotaSpec hard(Map<String, String> hard) {
        this.hard = hard;
        return this;
    }

    public V1ResourceQuotaSpec putHardItem(String key, String hardItem) {
        if (this.hard == null) {
            this.hard = new HashMap<String, String>();
        }
        this.hard.put(key, hardItem);
        return this;
    }

    @ApiModelProperty(value="Hard is the set of desired hard limits for each named resource. More info: https://git.k8s.io/community/contributors/design-proposals/admission_control_resource_quota.md")
    public Map<String, String> getHard() {
        return this.hard;
    }

    public void setHard(Map<String, String> hard) {
        this.hard = hard;
    }

    public V1ResourceQuotaSpec scopes(List<String> scopes) {
        this.scopes = scopes;
        return this;
    }

    public V1ResourceQuotaSpec addScopesItem(String scopesItem) {
        if (this.scopes == null) {
            this.scopes = new ArrayList<String>();
        }
        this.scopes.add(scopesItem);
        return this;
    }

    @ApiModelProperty(value="A collection of filters that must match each object tracked by a quota. If not specified, the quota matches all objects.")
    public List<String> getScopes() {
        return this.scopes;
    }

    public void setScopes(List<String> scopes) {
        this.scopes = scopes;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V1ResourceQuotaSpec v1ResourceQuotaSpec = (V1ResourceQuotaSpec)o;
        return Objects.equals(this.hard, v1ResourceQuotaSpec.hard) && Objects.equals(this.scopes, v1ResourceQuotaSpec.scopes);
    }

    public int hashCode() {
        return Objects.hash(this.hard, this.scopes);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class V1ResourceQuotaSpec {\n");
        sb.append("    hard: ").append(this.toIndentedString(this.hard)).append("\n");
        sb.append("    scopes: ").append(this.toIndentedString(this.scopes)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

