/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.models;

import com.google.gson.annotations.SerializedName;
import io.kubernetes.client.models.V1alpha1Rule;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@ApiModel(description="Initializer describes the name and the failure policy of an initializer, and what resources it applies to.")
public class V1alpha1Initializer {
    @SerializedName(value="name")
    private String name = null;
    @SerializedName(value="rules")
    private List<V1alpha1Rule> rules = null;

    public V1alpha1Initializer name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(required=true, value="Name is the identifier of the initializer. It will be added to the object that needs to be initialized. Name should be fully qualified, e.g., alwayspullimages.kubernetes.io, where \"alwayspullimages\" is the name of the webhook, and kubernetes.io is the name of the organization. Required")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public V1alpha1Initializer rules(List<V1alpha1Rule> rules) {
        this.rules = rules;
        return this;
    }

    public V1alpha1Initializer addRulesItem(V1alpha1Rule rulesItem) {
        if (this.rules == null) {
            this.rules = new ArrayList<V1alpha1Rule>();
        }
        this.rules.add(rulesItem);
        return this;
    }

    @ApiModelProperty(value="Rules describes what resources/subresources the initializer cares about. The initializer cares about an operation if it matches _any_ Rule. Rule.Resources must not include subresources.")
    public List<V1alpha1Rule> getRules() {
        return this.rules;
    }

    public void setRules(List<V1alpha1Rule> rules) {
        this.rules = rules;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V1alpha1Initializer v1alpha1Initializer = (V1alpha1Initializer)o;
        return Objects.equals(this.name, v1alpha1Initializer.name) && Objects.equals(this.rules, v1alpha1Initializer.rules);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.rules);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class V1alpha1Initializer {\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    rules: ").append(this.toIndentedString(this.rules)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

