/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.models;

import io.kubernetes.client.fluent.BaseFluent;
import io.kubernetes.client.fluent.Nested;
import io.kubernetes.client.openapi.models.V1beta2DeviceRequestAllocationResult;
import io.kubernetes.client.openapi.models.V1beta2DeviceToleration;
import io.kubernetes.client.openapi.models.V1beta2DeviceTolerationBuilder;
import io.kubernetes.client.openapi.models.V1beta2DeviceTolerationFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;

public class V1beta2DeviceRequestAllocationResultFluent<A extends V1beta2DeviceRequestAllocationResultFluent<A>>
extends BaseFluent<A> {
    private Boolean adminAccess;
    private String device;
    private String driver;
    private String pool;
    private String request;
    private ArrayList<V1beta2DeviceTolerationBuilder> tolerations;

    public V1beta2DeviceRequestAllocationResultFluent() {
    }

    public V1beta2DeviceRequestAllocationResultFluent(V1beta2DeviceRequestAllocationResult instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(V1beta2DeviceRequestAllocationResult instance) {
        V1beta2DeviceRequestAllocationResult v1beta2DeviceRequestAllocationResult = instance = instance != null ? instance : new V1beta2DeviceRequestAllocationResult();
        if (instance != null) {
            this.withAdminAccess(instance.getAdminAccess());
            this.withDevice(instance.getDevice());
            this.withDriver(instance.getDriver());
            this.withPool(instance.getPool());
            this.withRequest(instance.getRequest());
            this.withTolerations(instance.getTolerations());
        }
    }

    public Boolean getAdminAccess() {
        return this.adminAccess;
    }

    public A withAdminAccess(Boolean adminAccess) {
        this.adminAccess = adminAccess;
        return (A)this;
    }

    public boolean hasAdminAccess() {
        return this.adminAccess != null;
    }

    public String getDevice() {
        return this.device;
    }

    public A withDevice(String device) {
        this.device = device;
        return (A)this;
    }

    public boolean hasDevice() {
        return this.device != null;
    }

    public String getDriver() {
        return this.driver;
    }

    public A withDriver(String driver) {
        this.driver = driver;
        return (A)this;
    }

    public boolean hasDriver() {
        return this.driver != null;
    }

    public String getPool() {
        return this.pool;
    }

    public A withPool(String pool) {
        this.pool = pool;
        return (A)this;
    }

    public boolean hasPool() {
        return this.pool != null;
    }

    public String getRequest() {
        return this.request;
    }

    public A withRequest(String request) {
        this.request = request;
        return (A)this;
    }

    public boolean hasRequest() {
        return this.request != null;
    }

    public A addToTolerations(int index, V1beta2DeviceToleration item) {
        if (this.tolerations == null) {
            this.tolerations = new ArrayList();
        }
        V1beta2DeviceTolerationBuilder builder = new V1beta2DeviceTolerationBuilder(item);
        if (index < 0 || index >= this.tolerations.size()) {
            this._visitables.get("tolerations").add(builder);
            this.tolerations.add(builder);
        } else {
            this._visitables.get("tolerations").add(builder);
            this.tolerations.add(index, builder);
        }
        return (A)this;
    }

    public A setToTolerations(int index, V1beta2DeviceToleration item) {
        if (this.tolerations == null) {
            this.tolerations = new ArrayList();
        }
        V1beta2DeviceTolerationBuilder builder = new V1beta2DeviceTolerationBuilder(item);
        if (index < 0 || index >= this.tolerations.size()) {
            this._visitables.get("tolerations").add(builder);
            this.tolerations.add(builder);
        } else {
            this._visitables.get("tolerations").add(builder);
            this.tolerations.set(index, builder);
        }
        return (A)this;
    }

    public A addToTolerations(V1beta2DeviceToleration ... items) {
        if (this.tolerations == null) {
            this.tolerations = new ArrayList();
        }
        for (V1beta2DeviceToleration item : items) {
            V1beta2DeviceTolerationBuilder builder = new V1beta2DeviceTolerationBuilder(item);
            this._visitables.get("tolerations").add(builder);
            this.tolerations.add(builder);
        }
        return (A)this;
    }

    public A addAllToTolerations(Collection<V1beta2DeviceToleration> items) {
        if (this.tolerations == null) {
            this.tolerations = new ArrayList();
        }
        for (V1beta2DeviceToleration item : items) {
            V1beta2DeviceTolerationBuilder builder = new V1beta2DeviceTolerationBuilder(item);
            this._visitables.get("tolerations").add(builder);
            this.tolerations.add(builder);
        }
        return (A)this;
    }

    public A removeFromTolerations(V1beta2DeviceToleration ... items) {
        if (this.tolerations == null) {
            return (A)this;
        }
        for (V1beta2DeviceToleration item : items) {
            V1beta2DeviceTolerationBuilder builder = new V1beta2DeviceTolerationBuilder(item);
            this._visitables.get("tolerations").remove(builder);
            this.tolerations.remove(builder);
        }
        return (A)this;
    }

    public A removeAllFromTolerations(Collection<V1beta2DeviceToleration> items) {
        if (this.tolerations == null) {
            return (A)this;
        }
        for (V1beta2DeviceToleration item : items) {
            V1beta2DeviceTolerationBuilder builder = new V1beta2DeviceTolerationBuilder(item);
            this._visitables.get("tolerations").remove(builder);
            this.tolerations.remove(builder);
        }
        return (A)this;
    }

    public A removeMatchingFromTolerations(Predicate<V1beta2DeviceTolerationBuilder> predicate) {
        if (this.tolerations == null) {
            return (A)this;
        }
        Iterator<V1beta2DeviceTolerationBuilder> each = this.tolerations.iterator();
        Object visitables = this._visitables.get("tolerations");
        while (each.hasNext()) {
            V1beta2DeviceTolerationBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    public List<V1beta2DeviceToleration> buildTolerations() {
        return this.tolerations != null ? V1beta2DeviceRequestAllocationResultFluent.build(this.tolerations) : null;
    }

    public V1beta2DeviceToleration buildToleration(int index) {
        return this.tolerations.get(index).build();
    }

    public V1beta2DeviceToleration buildFirstToleration() {
        return this.tolerations.get(0).build();
    }

    public V1beta2DeviceToleration buildLastToleration() {
        return this.tolerations.get(this.tolerations.size() - 1).build();
    }

    public V1beta2DeviceToleration buildMatchingToleration(Predicate<V1beta2DeviceTolerationBuilder> predicate) {
        for (V1beta2DeviceTolerationBuilder item : this.tolerations) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingToleration(Predicate<V1beta2DeviceTolerationBuilder> predicate) {
        for (V1beta2DeviceTolerationBuilder item : this.tolerations) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withTolerations(List<V1beta2DeviceToleration> tolerations) {
        if (this.tolerations != null) {
            this._visitables.get("tolerations").clear();
        }
        if (tolerations != null) {
            this.tolerations = new ArrayList();
            for (V1beta2DeviceToleration item : tolerations) {
                this.addToTolerations(item);
            }
        } else {
            this.tolerations = null;
        }
        return (A)this;
    }

    public A withTolerations(V1beta2DeviceToleration ... tolerations) {
        if (this.tolerations != null) {
            this.tolerations.clear();
            this._visitables.remove("tolerations");
        }
        if (tolerations != null) {
            for (V1beta2DeviceToleration item : tolerations) {
                this.addToTolerations(item);
            }
        }
        return (A)this;
    }

    public boolean hasTolerations() {
        return this.tolerations != null && !this.tolerations.isEmpty();
    }

    public TolerationsNested<A> addNewToleration() {
        return new TolerationsNested(-1, null);
    }

    public TolerationsNested<A> addNewTolerationLike(V1beta2DeviceToleration item) {
        return new TolerationsNested(-1, item);
    }

    public TolerationsNested<A> setNewTolerationLike(int index, V1beta2DeviceToleration item) {
        return new TolerationsNested(index, item);
    }

    public TolerationsNested<A> editToleration(int index) {
        if (this.tolerations.size() <= index) {
            throw new RuntimeException("Can't edit tolerations. Index exceeds size.");
        }
        return this.setNewTolerationLike(index, this.buildToleration(index));
    }

    public TolerationsNested<A> editFirstToleration() {
        if (this.tolerations.size() == 0) {
            throw new RuntimeException("Can't edit first tolerations. The list is empty.");
        }
        return this.setNewTolerationLike(0, this.buildToleration(0));
    }

    public TolerationsNested<A> editLastToleration() {
        int index = this.tolerations.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last tolerations. The list is empty.");
        }
        return this.setNewTolerationLike(index, this.buildToleration(index));
    }

    public TolerationsNested<A> editMatchingToleration(Predicate<V1beta2DeviceTolerationBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.tolerations.size(); ++i) {
            if (!predicate.test(this.tolerations.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching tolerations. No match found.");
        }
        return this.setNewTolerationLike(index, this.buildToleration(index));
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        V1beta2DeviceRequestAllocationResultFluent that = (V1beta2DeviceRequestAllocationResultFluent)o;
        if (!Objects.equals(this.adminAccess, that.adminAccess)) {
            return false;
        }
        if (!Objects.equals(this.device, that.device)) {
            return false;
        }
        if (!Objects.equals(this.driver, that.driver)) {
            return false;
        }
        if (!Objects.equals(this.pool, that.pool)) {
            return false;
        }
        if (!Objects.equals(this.request, that.request)) {
            return false;
        }
        return Objects.equals(this.tolerations, that.tolerations);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.adminAccess, this.device, this.driver, this.pool, this.request, this.tolerations, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.adminAccess != null) {
            sb.append("adminAccess:");
            sb.append(this.adminAccess + ",");
        }
        if (this.device != null) {
            sb.append("device:");
            sb.append(this.device + ",");
        }
        if (this.driver != null) {
            sb.append("driver:");
            sb.append(this.driver + ",");
        }
        if (this.pool != null) {
            sb.append("pool:");
            sb.append(this.pool + ",");
        }
        if (this.request != null) {
            sb.append("request:");
            sb.append(this.request + ",");
        }
        if (this.tolerations != null && !this.tolerations.isEmpty()) {
            sb.append("tolerations:");
            sb.append(this.tolerations);
        }
        sb.append("}");
        return sb.toString();
    }

    public A withAdminAccess() {
        return this.withAdminAccess(true);
    }

    public class TolerationsNested<N>
    extends V1beta2DeviceTolerationFluent<TolerationsNested<N>>
    implements Nested<N> {
        V1beta2DeviceTolerationBuilder builder;
        int index;

        TolerationsNested(int index, V1beta2DeviceToleration item) {
            this.index = index;
            this.builder = new V1beta2DeviceTolerationBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)V1beta2DeviceRequestAllocationResultFluent.this.setToTolerations(this.index, this.builder.build());
        }

        public N endToleration() {
            return this.and();
        }
    }
}

