/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.models;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.kubernetes.client.openapi.JSON;
import io.kubernetes.client.openapi.models.V1beta2DeviceToleration;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

@ApiModel(description="DeviceRequestAllocationResult contains the allocation result for one request.")
public class V1beta2DeviceRequestAllocationResult {
    public static final String SERIALIZED_NAME_ADMIN_ACCESS = "adminAccess";
    @SerializedName(value="adminAccess")
    @Nullable
    private Boolean adminAccess;
    public static final String SERIALIZED_NAME_DEVICE = "device";
    @SerializedName(value="device")
    @Nonnull
    private String device;
    public static final String SERIALIZED_NAME_DRIVER = "driver";
    @SerializedName(value="driver")
    @Nonnull
    private String driver;
    public static final String SERIALIZED_NAME_POOL = "pool";
    @SerializedName(value="pool")
    @Nonnull
    private String pool;
    public static final String SERIALIZED_NAME_REQUEST = "request";
    @SerializedName(value="request")
    @Nonnull
    private String request;
    public static final String SERIALIZED_NAME_TOLERATIONS = "tolerations";
    @SerializedName(value="tolerations")
    @Nullable
    private List<V1beta2DeviceToleration> tolerations = new ArrayList<V1beta2DeviceToleration>();
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public V1beta2DeviceRequestAllocationResult adminAccess(@Nullable Boolean adminAccess) {
        this.adminAccess = adminAccess;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="AdminAccess indicates that this device was allocated for administrative access. See the corresponding request field for a definition of mode.  This is an alpha field and requires enabling the DRAAdminAccess feature gate. Admin access is disabled if this field is unset or set to false, otherwise it is enabled.")
    public Boolean getAdminAccess() {
        return this.adminAccess;
    }

    public void setAdminAccess(@Nullable Boolean adminAccess) {
        this.adminAccess = adminAccess;
    }

    public V1beta2DeviceRequestAllocationResult device(@Nonnull String device) {
        this.device = device;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="Device references one device instance via its name in the driver's resource pool. It must be a DNS label.")
    public String getDevice() {
        return this.device;
    }

    public void setDevice(@Nonnull String device) {
        this.device = device;
    }

    public V1beta2DeviceRequestAllocationResult driver(@Nonnull String driver) {
        this.driver = driver;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="Driver specifies the name of the DRA driver whose kubelet plugin should be invoked to process the allocation once the claim is needed on a node.  Must be a DNS subdomain and should end with a DNS domain owned by the vendor of the driver.")
    public String getDriver() {
        return this.driver;
    }

    public void setDriver(@Nonnull String driver) {
        this.driver = driver;
    }

    public V1beta2DeviceRequestAllocationResult pool(@Nonnull String pool) {
        this.pool = pool;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="This name together with the driver name and the device name field identify which device was allocated (`<driver name>/<pool name>/<device name>`).  Must not be longer than 253 characters and may contain one or more DNS sub-domains separated by slashes.")
    public String getPool() {
        return this.pool;
    }

    public void setPool(@Nonnull String pool) {
        this.pool = pool;
    }

    public V1beta2DeviceRequestAllocationResult request(@Nonnull String request) {
        this.request = request;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="Request is the name of the request in the claim which caused this device to be allocated. If it references a subrequest in the firstAvailable list on a DeviceRequest, this field must include both the name of the main request and the subrequest using the format <main request>/<subrequest>.  Multiple devices may have been allocated per request.")
    public String getRequest() {
        return this.request;
    }

    public void setRequest(@Nonnull String request) {
        this.request = request;
    }

    public V1beta2DeviceRequestAllocationResult tolerations(@Nullable List<V1beta2DeviceToleration> tolerations) {
        this.tolerations = tolerations;
        return this;
    }

    public V1beta2DeviceRequestAllocationResult addTolerationsItem(V1beta2DeviceToleration tolerationsItem) {
        if (this.tolerations == null) {
            this.tolerations = new ArrayList<V1beta2DeviceToleration>();
        }
        this.tolerations.add(tolerationsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="A copy of all tolerations specified in the request at the time when the device got allocated.  The maximum number of tolerations is 16.  This is an alpha field and requires enabling the DRADeviceTaints feature gate.")
    public List<V1beta2DeviceToleration> getTolerations() {
        return this.tolerations;
    }

    public void setTolerations(@Nullable List<V1beta2DeviceToleration> tolerations) {
        this.tolerations = tolerations;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V1beta2DeviceRequestAllocationResult v1beta2DeviceRequestAllocationResult = (V1beta2DeviceRequestAllocationResult)o;
        return Objects.equals(this.adminAccess, v1beta2DeviceRequestAllocationResult.adminAccess) && Objects.equals(this.device, v1beta2DeviceRequestAllocationResult.device) && Objects.equals(this.driver, v1beta2DeviceRequestAllocationResult.driver) && Objects.equals(this.pool, v1beta2DeviceRequestAllocationResult.pool) && Objects.equals(this.request, v1beta2DeviceRequestAllocationResult.request) && Objects.equals(this.tolerations, v1beta2DeviceRequestAllocationResult.tolerations);
    }

    public int hashCode() {
        return Objects.hash(this.adminAccess, this.device, this.driver, this.pool, this.request, this.tolerations);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class V1beta2DeviceRequestAllocationResult {\n");
        sb.append("    adminAccess: ").append(this.toIndentedString(this.adminAccess)).append("\n");
        sb.append("    device: ").append(this.toIndentedString(this.device)).append("\n");
        sb.append("    driver: ").append(this.toIndentedString(this.driver)).append("\n");
        sb.append("    pool: ").append(this.toIndentedString(this.pool)).append("\n");
        sb.append("    request: ").append(this.toIndentedString(this.request)).append("\n");
        sb.append("    tolerations: ").append(this.toIndentedString(this.tolerations)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonElement(JsonElement jsonElement) throws IOException {
        JsonArray jsonArraytolerations;
        if (jsonElement == null && !openapiRequiredFields.isEmpty()) {
            throw new IllegalArgumentException(String.format("The required field(s) %s in V1beta2DeviceRequestAllocationResult is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        Set entries = jsonElement.getAsJsonObject().entrySet();
        for (Map.Entry entry : entries) {
            if (openapiFields.contains(entry.getKey())) continue;
            throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `V1beta2DeviceRequestAllocationResult` properties. JSON: %s", entry.getKey(), jsonElement.toString()));
        }
        for (String requiredField : openapiRequiredFields) {
            if (jsonElement.getAsJsonObject().get(requiredField) != null) continue;
            throw new IllegalArgumentException(String.format("The required field `%s` is not found in the JSON string: %s", requiredField, jsonElement.toString()));
        }
        JsonObject jsonObj = jsonElement.getAsJsonObject();
        if (!jsonObj.get(SERIALIZED_NAME_DEVICE).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `device` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_DEVICE).toString()));
        }
        if (!jsonObj.get(SERIALIZED_NAME_DRIVER).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `driver` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_DRIVER).toString()));
        }
        if (!jsonObj.get(SERIALIZED_NAME_POOL).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `pool` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_POOL).toString()));
        }
        if (!jsonObj.get(SERIALIZED_NAME_REQUEST).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `request` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_REQUEST).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_TOLERATIONS) != null && !jsonObj.get(SERIALIZED_NAME_TOLERATIONS).isJsonNull() && (jsonArraytolerations = jsonObj.getAsJsonArray(SERIALIZED_NAME_TOLERATIONS)) != null) {
            if (!jsonObj.get(SERIALIZED_NAME_TOLERATIONS).isJsonArray()) {
                throw new IllegalArgumentException(String.format("Expected the field `tolerations` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_TOLERATIONS).toString()));
            }
            for (int i = 0; i < jsonArraytolerations.size(); ++i) {
                V1beta2DeviceToleration.validateJsonElement(jsonArraytolerations.get(i));
            }
        }
    }

    public static V1beta2DeviceRequestAllocationResult fromJson(String jsonString) throws IOException {
        return (V1beta2DeviceRequestAllocationResult)JSON.getGson().fromJson(jsonString, V1beta2DeviceRequestAllocationResult.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_ADMIN_ACCESS);
        openapiFields.add(SERIALIZED_NAME_DEVICE);
        openapiFields.add(SERIALIZED_NAME_DRIVER);
        openapiFields.add(SERIALIZED_NAME_POOL);
        openapiFields.add(SERIALIZED_NAME_REQUEST);
        openapiFields.add(SERIALIZED_NAME_TOLERATIONS);
        openapiRequiredFields = new HashSet();
        openapiRequiredFields.add(SERIALIZED_NAME_DEVICE);
        openapiRequiredFields.add(SERIALIZED_NAME_DRIVER);
        openapiRequiredFields.add(SERIALIZED_NAME_POOL);
        openapiRequiredFields.add(SERIALIZED_NAME_REQUEST);
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!V1beta2DeviceRequestAllocationResult.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(V1beta2DeviceRequestAllocationResult.class));
            return new TypeAdapter<V1beta2DeviceRequestAllocationResult>(){

                public void write(JsonWriter out, V1beta2DeviceRequestAllocationResult value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    elementAdapter.write(out, (Object)obj);
                }

                public V1beta2DeviceRequestAllocationResult read(JsonReader in) throws IOException {
                    JsonElement jsonElement = (JsonElement)elementAdapter.read(in);
                    V1beta2DeviceRequestAllocationResult.validateJsonElement(jsonElement);
                    return (V1beta2DeviceRequestAllocationResult)thisAdapter.fromJsonTree(jsonElement);
                }
            }.nullSafe();
        }
    }
}

