/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.models;

import io.kubernetes.client.fluent.BaseFluent;
import io.kubernetes.client.fluent.Nested;
import io.kubernetes.client.openapi.models.V1NodeSelector;
import io.kubernetes.client.openapi.models.V1NodeSelectorBuilder;
import io.kubernetes.client.openapi.models.V1NodeSelectorFluent;
import io.kubernetes.client.openapi.models.V1beta1AllocationResult;
import io.kubernetes.client.openapi.models.V1beta1DeviceAllocationResult;
import io.kubernetes.client.openapi.models.V1beta1DeviceAllocationResultBuilder;
import io.kubernetes.client.openapi.models.V1beta1DeviceAllocationResultFluent;
import java.util.Objects;
import java.util.Optional;

public class V1beta1AllocationResultFluent<A extends V1beta1AllocationResultFluent<A>>
extends BaseFluent<A> {
    private V1beta1DeviceAllocationResultBuilder devices;
    private V1NodeSelectorBuilder nodeSelector;

    public V1beta1AllocationResultFluent() {
    }

    public V1beta1AllocationResultFluent(V1beta1AllocationResult instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(V1beta1AllocationResult instance) {
        V1beta1AllocationResult v1beta1AllocationResult = instance = instance != null ? instance : new V1beta1AllocationResult();
        if (instance != null) {
            this.withDevices(instance.getDevices());
            this.withNodeSelector(instance.getNodeSelector());
        }
    }

    public V1beta1DeviceAllocationResult buildDevices() {
        return this.devices != null ? this.devices.build() : null;
    }

    public A withDevices(V1beta1DeviceAllocationResult devices) {
        this._visitables.remove("devices");
        if (devices != null) {
            this.devices = new V1beta1DeviceAllocationResultBuilder(devices);
            this._visitables.get("devices").add(this.devices);
        } else {
            this.devices = null;
            this._visitables.get("devices").remove(this.devices);
        }
        return (A)this;
    }

    public boolean hasDevices() {
        return this.devices != null;
    }

    public DevicesNested<A> withNewDevices() {
        return new DevicesNested(null);
    }

    public DevicesNested<A> withNewDevicesLike(V1beta1DeviceAllocationResult item) {
        return new DevicesNested(item);
    }

    public DevicesNested<A> editDevices() {
        return this.withNewDevicesLike(Optional.ofNullable(this.buildDevices()).orElse(null));
    }

    public DevicesNested<A> editOrNewDevices() {
        return this.withNewDevicesLike(Optional.ofNullable(this.buildDevices()).orElse(new V1beta1DeviceAllocationResultBuilder().build()));
    }

    public DevicesNested<A> editOrNewDevicesLike(V1beta1DeviceAllocationResult item) {
        return this.withNewDevicesLike(Optional.ofNullable(this.buildDevices()).orElse(item));
    }

    public V1NodeSelector buildNodeSelector() {
        return this.nodeSelector != null ? this.nodeSelector.build() : null;
    }

    public A withNodeSelector(V1NodeSelector nodeSelector) {
        this._visitables.remove("nodeSelector");
        if (nodeSelector != null) {
            this.nodeSelector = new V1NodeSelectorBuilder(nodeSelector);
            this._visitables.get("nodeSelector").add(this.nodeSelector);
        } else {
            this.nodeSelector = null;
            this._visitables.get("nodeSelector").remove(this.nodeSelector);
        }
        return (A)this;
    }

    public boolean hasNodeSelector() {
        return this.nodeSelector != null;
    }

    public NodeSelectorNested<A> withNewNodeSelector() {
        return new NodeSelectorNested(null);
    }

    public NodeSelectorNested<A> withNewNodeSelectorLike(V1NodeSelector item) {
        return new NodeSelectorNested(item);
    }

    public NodeSelectorNested<A> editNodeSelector() {
        return this.withNewNodeSelectorLike(Optional.ofNullable(this.buildNodeSelector()).orElse(null));
    }

    public NodeSelectorNested<A> editOrNewNodeSelector() {
        return this.withNewNodeSelectorLike(Optional.ofNullable(this.buildNodeSelector()).orElse(new V1NodeSelectorBuilder().build()));
    }

    public NodeSelectorNested<A> editOrNewNodeSelectorLike(V1NodeSelector item) {
        return this.withNewNodeSelectorLike(Optional.ofNullable(this.buildNodeSelector()).orElse(item));
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        V1beta1AllocationResultFluent that = (V1beta1AllocationResultFluent)o;
        if (!Objects.equals(this.devices, that.devices)) {
            return false;
        }
        return Objects.equals(this.nodeSelector, that.nodeSelector);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.devices, this.nodeSelector, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.devices != null) {
            sb.append("devices:");
            sb.append(String.valueOf(this.devices) + ",");
        }
        if (this.nodeSelector != null) {
            sb.append("nodeSelector:");
            sb.append(this.nodeSelector);
        }
        sb.append("}");
        return sb.toString();
    }

    public class DevicesNested<N>
    extends V1beta1DeviceAllocationResultFluent<DevicesNested<N>>
    implements Nested<N> {
        V1beta1DeviceAllocationResultBuilder builder;

        DevicesNested(V1beta1DeviceAllocationResult item) {
            this.builder = new V1beta1DeviceAllocationResultBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)V1beta1AllocationResultFluent.this.withDevices(this.builder.build());
        }

        public N endDevices() {
            return this.and();
        }
    }

    public class NodeSelectorNested<N>
    extends V1NodeSelectorFluent<NodeSelectorNested<N>>
    implements Nested<N> {
        V1NodeSelectorBuilder builder;

        NodeSelectorNested(V1NodeSelector item) {
            this.builder = new V1NodeSelectorBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)V1beta1AllocationResultFluent.this.withNodeSelector(this.builder.build());
        }

        public N endNodeSelector() {
            return this.and();
        }
    }
}

