/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.models;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.kubernetes.client.openapi.JSON;
import io.kubernetes.client.openapi.models.V1LifecycleHandler;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import jakarta.annotation.Nullable;
import java.io.IOException;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

@ApiModel(description="Lifecycle describes actions that the management system should take in response to container lifecycle events. For the PostStart and PreStop lifecycle handlers, management of the container blocks until the action is complete, unless the container process fails, in which case the handler is aborted.")
public class V1Lifecycle {
    public static final String SERIALIZED_NAME_POST_START = "postStart";
    @SerializedName(value="postStart")
    @Nullable
    private V1LifecycleHandler postStart;
    public static final String SERIALIZED_NAME_PRE_STOP = "preStop";
    @SerializedName(value="preStop")
    @Nullable
    private V1LifecycleHandler preStop;
    public static final String SERIALIZED_NAME_STOP_SIGNAL = "stopSignal";
    @SerializedName(value="stopSignal")
    @Nullable
    private String stopSignal;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public V1Lifecycle postStart(@Nullable V1LifecycleHandler postStart) {
        this.postStart = postStart;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public V1LifecycleHandler getPostStart() {
        return this.postStart;
    }

    public void setPostStart(@Nullable V1LifecycleHandler postStart) {
        this.postStart = postStart;
    }

    public V1Lifecycle preStop(@Nullable V1LifecycleHandler preStop) {
        this.preStop = preStop;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public V1LifecycleHandler getPreStop() {
        return this.preStop;
    }

    public void setPreStop(@Nullable V1LifecycleHandler preStop) {
        this.preStop = preStop;
    }

    public V1Lifecycle stopSignal(@Nullable String stopSignal) {
        this.stopSignal = stopSignal;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="StopSignal defines which signal will be sent to a container when it is being stopped. If not specified, the default is defined by the container runtime in use. StopSignal can only be set for Pods with a non-empty .spec.os.name")
    public String getStopSignal() {
        return this.stopSignal;
    }

    public void setStopSignal(@Nullable String stopSignal) {
        this.stopSignal = stopSignal;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V1Lifecycle v1Lifecycle = (V1Lifecycle)o;
        return Objects.equals(this.postStart, v1Lifecycle.postStart) && Objects.equals(this.preStop, v1Lifecycle.preStop) && Objects.equals(this.stopSignal, v1Lifecycle.stopSignal);
    }

    public int hashCode() {
        return Objects.hash(this.postStart, this.preStop, this.stopSignal);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class V1Lifecycle {\n");
        sb.append("    postStart: ").append(this.toIndentedString(this.postStart)).append("\n");
        sb.append("    preStop: ").append(this.toIndentedString(this.preStop)).append("\n");
        sb.append("    stopSignal: ").append(this.toIndentedString(this.stopSignal)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonElement(JsonElement jsonElement) throws IOException {
        if (jsonElement == null && !openapiRequiredFields.isEmpty()) {
            throw new IllegalArgumentException(String.format("The required field(s) %s in V1Lifecycle is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        Set entries = jsonElement.getAsJsonObject().entrySet();
        for (Map.Entry entry : entries) {
            if (openapiFields.contains(entry.getKey())) continue;
            throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `V1Lifecycle` properties. JSON: %s", entry.getKey(), jsonElement.toString()));
        }
        JsonObject jsonObj = jsonElement.getAsJsonObject();
        if (jsonObj.get(SERIALIZED_NAME_POST_START) != null && !jsonObj.get(SERIALIZED_NAME_POST_START).isJsonNull()) {
            V1LifecycleHandler.validateJsonElement(jsonObj.get(SERIALIZED_NAME_POST_START));
        }
        if (jsonObj.get(SERIALIZED_NAME_PRE_STOP) != null && !jsonObj.get(SERIALIZED_NAME_PRE_STOP).isJsonNull()) {
            V1LifecycleHandler.validateJsonElement(jsonObj.get(SERIALIZED_NAME_PRE_STOP));
        }
        if (jsonObj.get(SERIALIZED_NAME_STOP_SIGNAL) != null && !jsonObj.get(SERIALIZED_NAME_STOP_SIGNAL).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_STOP_SIGNAL).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `stopSignal` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_STOP_SIGNAL).toString()));
        }
    }

    public static V1Lifecycle fromJson(String jsonString) throws IOException {
        return (V1Lifecycle)JSON.getGson().fromJson(jsonString, V1Lifecycle.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_POST_START);
        openapiFields.add(SERIALIZED_NAME_PRE_STOP);
        openapiFields.add(SERIALIZED_NAME_STOP_SIGNAL);
        openapiRequiredFields = new HashSet();
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!V1Lifecycle.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(V1Lifecycle.class));
            return new TypeAdapter<V1Lifecycle>(){

                public void write(JsonWriter out, V1Lifecycle value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    elementAdapter.write(out, (Object)obj);
                }

                public V1Lifecycle read(JsonReader in) throws IOException {
                    JsonElement jsonElement = (JsonElement)elementAdapter.read(in);
                    V1Lifecycle.validateJsonElement(jsonElement);
                    return (V1Lifecycle)thisAdapter.fromJsonTree(jsonElement);
                }
            }.nullSafe();
        }
    }
}

