/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.models;

import io.kubernetes.client.fluent.BaseFluent;
import io.kubernetes.client.openapi.models.V1CertificateSigningRequestSpec;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;

public class V1CertificateSigningRequestSpecFluent<A extends V1CertificateSigningRequestSpecFluent<A>>
extends BaseFluent<A> {
    private Integer expirationSeconds;
    private Map<String, List<String>> extra;
    private List<String> groups;
    private List<Byte> request;
    private String signerName;
    private String uid;
    private List<String> usages;
    private String username;

    public V1CertificateSigningRequestSpecFluent() {
    }

    public V1CertificateSigningRequestSpecFluent(V1CertificateSigningRequestSpec instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(V1CertificateSigningRequestSpec instance) {
        V1CertificateSigningRequestSpec v1CertificateSigningRequestSpec = instance = instance != null ? instance : new V1CertificateSigningRequestSpec();
        if (instance != null) {
            this.withExpirationSeconds(instance.getExpirationSeconds());
            this.withExtra(instance.getExtra());
            this.withGroups(instance.getGroups());
            this.withRequest(instance.getRequest());
            this.withSignerName(instance.getSignerName());
            this.withUid(instance.getUid());
            this.withUsages(instance.getUsages());
            this.withUsername(instance.getUsername());
        }
    }

    public Integer getExpirationSeconds() {
        return this.expirationSeconds;
    }

    public A withExpirationSeconds(Integer expirationSeconds) {
        this.expirationSeconds = expirationSeconds;
        return (A)this;
    }

    public boolean hasExpirationSeconds() {
        return this.expirationSeconds != null;
    }

    public A addToExtra(String key, List<String> value) {
        if (this.extra == null && key != null && value != null) {
            this.extra = new LinkedHashMap<String, List<String>>();
        }
        if (key != null && value != null) {
            this.extra.put(key, value);
        }
        return (A)this;
    }

    public A addToExtra(Map<String, List<String>> map) {
        if (this.extra == null && map != null) {
            this.extra = new LinkedHashMap<String, List<String>>();
        }
        if (map != null) {
            this.extra.putAll(map);
        }
        return (A)this;
    }

    public A removeFromExtra(String key) {
        if (this.extra == null) {
            return (A)this;
        }
        if (key != null && this.extra != null) {
            this.extra.remove(key);
        }
        return (A)this;
    }

    public A removeFromExtra(Map<String, List<String>> map) {
        if (this.extra == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.extra == null) continue;
                this.extra.remove(key);
            }
        }
        return (A)this;
    }

    public Map<String, List<String>> getExtra() {
        return this.extra;
    }

    public <K, V> A withExtra(Map<String, List<String>> extra) {
        this.extra = extra == null ? null : new LinkedHashMap<String, List<String>>(extra);
        return (A)this;
    }

    public boolean hasExtra() {
        return this.extra != null;
    }

    public A addToGroups(int index, String item) {
        if (this.groups == null) {
            this.groups = new ArrayList<String>();
        }
        this.groups.add(index, item);
        return (A)this;
    }

    public A setToGroups(int index, String item) {
        if (this.groups == null) {
            this.groups = new ArrayList<String>();
        }
        this.groups.set(index, item);
        return (A)this;
    }

    public A addToGroups(String ... items) {
        if (this.groups == null) {
            this.groups = new ArrayList<String>();
        }
        for (String item : items) {
            this.groups.add(item);
        }
        return (A)this;
    }

    public A addAllToGroups(Collection<String> items) {
        if (this.groups == null) {
            this.groups = new ArrayList<String>();
        }
        for (String item : items) {
            this.groups.add(item);
        }
        return (A)this;
    }

    public A removeFromGroups(String ... items) {
        if (this.groups == null) {
            return (A)this;
        }
        for (String item : items) {
            this.groups.remove(item);
        }
        return (A)this;
    }

    public A removeAllFromGroups(Collection<String> items) {
        if (this.groups == null) {
            return (A)this;
        }
        for (String item : items) {
            this.groups.remove(item);
        }
        return (A)this;
    }

    public List<String> getGroups() {
        return this.groups;
    }

    public String getGroup(int index) {
        return this.groups.get(index);
    }

    public String getFirstGroup() {
        return this.groups.get(0);
    }

    public String getLastGroup() {
        return this.groups.get(this.groups.size() - 1);
    }

    public String getMatchingGroup(Predicate<String> predicate) {
        for (String item : this.groups) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    public boolean hasMatchingGroup(Predicate<String> predicate) {
        for (String item : this.groups) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withGroups(List<String> groups) {
        if (groups != null) {
            this.groups = new ArrayList<String>();
            for (String item : groups) {
                this.addToGroups(item);
            }
        } else {
            this.groups = null;
        }
        return (A)this;
    }

    public A withGroups(String ... groups) {
        if (this.groups != null) {
            this.groups.clear();
            this._visitables.remove("groups");
        }
        if (groups != null) {
            for (String item : groups) {
                this.addToGroups(item);
            }
        }
        return (A)this;
    }

    public boolean hasGroups() {
        return this.groups != null && !this.groups.isEmpty();
    }

    public A withRequest(byte ... request) {
        if (this.request != null) {
            this.request.clear();
            this._visitables.remove("request");
        }
        if (request != null) {
            for (byte item : request) {
                this.addToRequest(item);
            }
        }
        return (A)this;
    }

    public byte[] getRequest() {
        int size = this.request != null ? this.request.size() : 0;
        byte[] result = new byte[size];
        if (size == 0) {
            return result;
        }
        int index = 0;
        for (byte item : this.request) {
            result[index++] = item;
        }
        return result;
    }

    public A addToRequest(int index, Byte item) {
        if (this.request == null) {
            this.request = new ArrayList<Byte>();
        }
        this.request.add(index, item);
        return (A)this;
    }

    public A setToRequest(int index, Byte item) {
        if (this.request == null) {
            this.request = new ArrayList<Byte>();
        }
        this.request.set(index, item);
        return (A)this;
    }

    public A addToRequest(Byte ... items) {
        if (this.request == null) {
            this.request = new ArrayList<Byte>();
        }
        for (Byte item : items) {
            this.request.add(item);
        }
        return (A)this;
    }

    public A addAllToRequest(Collection<Byte> items) {
        if (this.request == null) {
            this.request = new ArrayList<Byte>();
        }
        for (Byte item : items) {
            this.request.add(item);
        }
        return (A)this;
    }

    public A removeFromRequest(Byte ... items) {
        if (this.request == null) {
            return (A)this;
        }
        for (Byte item : items) {
            this.request.remove(item);
        }
        return (A)this;
    }

    public A removeAllFromRequest(Collection<Byte> items) {
        if (this.request == null) {
            return (A)this;
        }
        for (Byte item : items) {
            this.request.remove(item);
        }
        return (A)this;
    }

    public boolean hasRequest() {
        return this.request != null && !this.request.isEmpty();
    }

    public String getSignerName() {
        return this.signerName;
    }

    public A withSignerName(String signerName) {
        this.signerName = signerName;
        return (A)this;
    }

    public boolean hasSignerName() {
        return this.signerName != null;
    }

    public String getUid() {
        return this.uid;
    }

    public A withUid(String uid) {
        this.uid = uid;
        return (A)this;
    }

    public boolean hasUid() {
        return this.uid != null;
    }

    public A addToUsages(int index, String item) {
        if (this.usages == null) {
            this.usages = new ArrayList<String>();
        }
        this.usages.add(index, item);
        return (A)this;
    }

    public A setToUsages(int index, String item) {
        if (this.usages == null) {
            this.usages = new ArrayList<String>();
        }
        this.usages.set(index, item);
        return (A)this;
    }

    public A addToUsages(String ... items) {
        if (this.usages == null) {
            this.usages = new ArrayList<String>();
        }
        for (String item : items) {
            this.usages.add(item);
        }
        return (A)this;
    }

    public A addAllToUsages(Collection<String> items) {
        if (this.usages == null) {
            this.usages = new ArrayList<String>();
        }
        for (String item : items) {
            this.usages.add(item);
        }
        return (A)this;
    }

    public A removeFromUsages(String ... items) {
        if (this.usages == null) {
            return (A)this;
        }
        for (String item : items) {
            this.usages.remove(item);
        }
        return (A)this;
    }

    public A removeAllFromUsages(Collection<String> items) {
        if (this.usages == null) {
            return (A)this;
        }
        for (String item : items) {
            this.usages.remove(item);
        }
        return (A)this;
    }

    public List<String> getUsages() {
        return this.usages;
    }

    public String getUsage(int index) {
        return this.usages.get(index);
    }

    public String getFirstUsage() {
        return this.usages.get(0);
    }

    public String getLastUsage() {
        return this.usages.get(this.usages.size() - 1);
    }

    public String getMatchingUsage(Predicate<String> predicate) {
        for (String item : this.usages) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    public boolean hasMatchingUsage(Predicate<String> predicate) {
        for (String item : this.usages) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withUsages(List<String> usages) {
        if (usages != null) {
            this.usages = new ArrayList<String>();
            for (String item : usages) {
                this.addToUsages(item);
            }
        } else {
            this.usages = null;
        }
        return (A)this;
    }

    public A withUsages(String ... usages) {
        if (this.usages != null) {
            this.usages.clear();
            this._visitables.remove("usages");
        }
        if (usages != null) {
            for (String item : usages) {
                this.addToUsages(item);
            }
        }
        return (A)this;
    }

    public boolean hasUsages() {
        return this.usages != null && !this.usages.isEmpty();
    }

    public String getUsername() {
        return this.username;
    }

    public A withUsername(String username) {
        this.username = username;
        return (A)this;
    }

    public boolean hasUsername() {
        return this.username != null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        V1CertificateSigningRequestSpecFluent that = (V1CertificateSigningRequestSpecFluent)o;
        if (!Objects.equals(this.expirationSeconds, that.expirationSeconds)) {
            return false;
        }
        if (!Objects.equals(this.extra, that.extra)) {
            return false;
        }
        if (!Objects.equals(this.groups, that.groups)) {
            return false;
        }
        if (!Objects.equals(this.request, that.request)) {
            return false;
        }
        if (!Objects.equals(this.signerName, that.signerName)) {
            return false;
        }
        if (!Objects.equals(this.uid, that.uid)) {
            return false;
        }
        if (!Objects.equals(this.usages, that.usages)) {
            return false;
        }
        return Objects.equals(this.username, that.username);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.expirationSeconds, this.extra, this.groups, this.request, this.signerName, this.uid, this.usages, this.username, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.expirationSeconds != null) {
            sb.append("expirationSeconds:");
            sb.append(this.expirationSeconds + ",");
        }
        if (this.extra != null && !this.extra.isEmpty()) {
            sb.append("extra:");
            sb.append(String.valueOf(this.extra) + ",");
        }
        if (this.groups != null && !this.groups.isEmpty()) {
            sb.append("groups:");
            sb.append(String.valueOf(this.groups) + ",");
        }
        if (this.request != null && !this.request.isEmpty()) {
            sb.append("request:");
            sb.append(String.valueOf(this.request) + ",");
        }
        if (this.signerName != null) {
            sb.append("signerName:");
            sb.append(this.signerName + ",");
        }
        if (this.uid != null) {
            sb.append("uid:");
            sb.append(this.uid + ",");
        }
        if (this.usages != null && !this.usages.isEmpty()) {
            sb.append("usages:");
            sb.append(String.valueOf(this.usages) + ",");
        }
        if (this.username != null) {
            sb.append("username:");
            sb.append(this.username);
        }
        sb.append("}");
        return sb.toString();
    }
}

